package cn.com.poc.common.constant;

public class ChangedLogConstant {

    public enum ChangedLogEnum{

        APPLICATION_ADD(BUSINESS_TYPE.APPLICATION,BUSINESS_DETAIL_TYPE.APPLICATION_ADD,REMARK.APPLICATION_ADD),
        APPLICATION_AUDITED(BUSINESS_TYPE.APPLICATION,BUSINESS_DETAIL_TYPE.APPLICATION_AUDITED,REMARK.APPLICATION_AUDITED),
        APPLICATION_CONFIRM(BUSINESS_TYPE.APPLICATION,BUSINESS_DETAIL_TYPE.APPLICATION_CONFIRM,REMARK.APPLICATION_CONFIRM),
        APPLICATION_COMPLETED(BUSINESS_TYPE.APPLICATION,BUSINESS_DETAIL_TYPE.APPLICATION_COMPLETED,REMARK.APPLICATION_COMPLETED),
        APPLICATION_REJECT(BUSINESS_TYPE.APPLICATION,BUSINESS_DETAIL_TYPE.APPLICATION_REJECT,REMARK.APPLICATION_REJECT);

        private String businessType;

        private String businessDetailType;

        private String remark;

        public String getBusinessDetailType() {
            return businessDetailType;
        }

        public void setBusinessDetailType(String businessDetailType) {
            this.businessDetailType = businessDetailType;
        }

        public String getBusinessType() {
            return businessType;
        }

        public void setBusinessType(String businessType) {
            this.businessType = businessType;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        ChangedLogEnum(String businessType, String businessDetailType, String remark) {
            this.businessType = businessType;
            this.businessDetailType = businessDetailType;
            this.remark = remark;
        }
    }

    public class BUSINESS_DETAIL_TYPE {

        public static final String CALL_CENTER = "CallCenter";

        public static final String RECALL = "Recall";

        public static final String LOST_ADD = "LostAdd";

        public static final String LOST_CHANGED = "LostChanged";

        public static final String APPLICATION_ADD = "ApplicationAdd";

        public static final String APPLICATION_AUDITED = "ApplicationAudited";

        public static final String APPLICATION_REJECT = "ApplicationReject";

        public static final String APPLICATION_COMPLETED = "ApplicationCompleted";

        public static final String APPLICATION_CONFIRM = "ApplicationComfirm";

        public static final String USER_RECEIVE = "UserReceive";

        public static final String USER_STORE_RECEIVE = "UserStoreReceive";

    }

    public class REMARK{

        public static final String APPLICATION_ADD = "创建申请单";

        public static final String APPLICATION_AUDITED = "通过申请单";

        public static final String APPLICATION_REJECT = "拒绝申请单";

        public static final String APPLICATION_COMPLETED = "放行申请单";

        public static final String APPLICATION_CONFIRM = "确认申请单";

    }

    public class BUSINESS_TYPE {

        public static final String LOST = "Lost";

        public static final String APPLICATION = "Application";

    }

}
