package cn.com.poc.common.domain;

import java.io.Serializable;

/**
 * 微信请求状态数据
 */
public class BaseResult implements Serializable {

  private static final String SUCCESS_CODE = "0";

  private String errcode;
  private String errmsg;

  public BaseResult() {
  }

  public BaseResult(String errcode, String errmsg) {
    this.errcode = errcode;
    this.errmsg = errmsg;
  }

  public String getErrcode() {
    return errcode;
  }

  public void setErrcode(String errcode) {
    this.errcode = errcode;
  }

  public String getErrmsg() {
    return errmsg;
  }

  public void setErrmsg(String errmsg) {
    this.errmsg = errmsg;
  }

  public boolean isSuccess() {
    return errcode == null || "".equals(errcode) || errcode.equals(SUCCESS_CODE);
  }

}
