package cn.com.poc.common.rest.impl;

import cn.com.poc.common.dto.SysErrorMessageDto;
import cn.com.poc.common.model.SysErrorLogModel;
import cn.com.poc.common.rest.SysErrorRest;
import cn.com.poc.common.service.SysErrorLogService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class SysErrorRestImpl implements SysErrorRest {

    @Resource
    private SysErrorLogService service;

    @Override
    public void report(SysErrorMessageDto dto) throws Exception {
        SysErrorLogModel sysErrorLogModel = new SysErrorLogModel();
        sysErrorLogModel.setErrorMessage(dto.getErrorMessage());
        service.save(sysErrorLogModel);
    }
}
