package cn.com.poc.common.utils;


import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListUtils extends org.apache.commons.collections.ListUtils {

	/**
	 * 集合是否为空
	 * @param list
	 * @return
	 * @author Will Chou
	 * @date 2015年8月17日 下午5:01:47
	 */
	public static boolean isEmpty(Collection<?> list) {
		if (list == null || list.size() < 1) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 集合是否不为空
	 * @param list
	 * @return
	 * @author Will Chou
	 * @date 2015年8月17日 下午5:02:07
	 */
	public static boolean isNotEmpty(Collection<?> list) {
		if (list != null && list.size() > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 拆分集合
	 *
	 * @param <T> 泛型对象
	 * @param resList 需要拆分的集合
	 * @param subListLength 每个子集合的元素个数
	 * @return 返回拆分后的各个集合组成的列表
	 * 代码里面用到了guava和common的结合工具类
	 **/
	public static <T> List<List<T>> split(List<T> resList, int subListLength) {
		if (CollectionUtils.isEmpty(resList) || subListLength <= 0) {
			return new ArrayList<>();
		}
		List<List<T>> ret = new ArrayList<>();
		int size = resList.size();
		if (size <= subListLength) {
			// 数据量不足 subListLength 指定的大小
			ret.add(resList);
		} else {
			int pre = size / subListLength;
			int last = size % subListLength;
			// 前面pre个集合，每个大小都是 subListLength 个元素
			for (int i = 0; i < pre; i++) {
				List<T> itemList = new ArrayList<>();
				for (int j = 0; j < subListLength; j++) {
					itemList.add(resList.get(i * subListLength + j));
				}
				ret.add(itemList);
			}
			// last的进行处理
			if (last > 0) {
				List<T> itemList = new ArrayList<>();
				for (int i = 0; i < last; i++) {
					itemList.add(resList.get(pre * subListLength + i));
				}
				ret.add(itemList);
			}
		}
		return ret;
	}
	

}
