package cn.com.poc.common.utils;


import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.function.Consumer;

public class PagingHelper {

    public static void doWithPaging(Integer pageSize, Consumer<PagingInfo> consumer) {
        pageSize = pageSize == null ? 10 : pageSize;
        PagingInfo pagingInfo = new PagingInfo(pageSize, 1);
        boolean first = true;
        while (first || pagingInfo.getPageNo() <= pagingInfo.getTotalPages()) {
            consumer.accept(pagingInfo);
            //下一页
            pagingInfo.setPageNo(pagingInfo.getPageNo() + 1);
            first = false;
        }
    }

}
