package cn.com.poc.common.utils;

import java.util.Random;

public class RandomCodeUtils {
    public static final String ALLCHAR = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String ALLNUM = "0123456789";

    /**
     * 返回一个定长的随机字符串(只包含大小写字母、数字)
     *
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String generateString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            sb.append(ALLCHAR.charAt(random.nextInt(ALLCHAR.length())));
        }
        return sb.toString();
    }

    /**
     * 返回一个定长的数字串
     *
     * @param length 随机字符串长度
     * @return 随机数字串
     */
    public static String generateNumber(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            sb.append(ALLNUM.charAt(random.nextInt(ALLNUM.length())));
        }
        return sb.toString();
    }


}