package cn.com.poc.expose.aggregate;

import cn.com.poc.agent_application.query.MemberCollectQueryItem;
import cn.com.yict.framemax.data.model.PagingInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface AgentApplicationService {

    /**
     * 调用 已发布Agent应用
     */
    void callAgentApplication(String agentId, String dialogsId, String input, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 追问AI生成
     *
     * @param input 问题输入
     * @return
     */
    List<String> createContinueQuestions(String input);

    /**
     * [首页] 获取推荐问
     *
     * @param xlang  语言 zh-cn 中文简体 en 英文 zh-tw 中文繁体
     * @param memberId 用户ID
     */
    List<String> getRecommendQuestions(String xlang, Long memberId) throws InterruptedException;

    /**
     * [首页] 生成推荐问
     *
     * @throws InterruptedException
     */
    void createRecommendQuestion();

    /**
     * 【首页】 获取用户已收藏的应用列表
     */
    List<MemberCollectQueryItem> getCollectedApplications(Long memberId, PagingInfo pagingInfo);

}
