package cn.com.poc.knowledge.convert;

import cn.com.poc.knowledge.model.BizKnowledgeInfoModel;
import cn.com.poc.knowledge.entity.BizKnowledgeInfoEntity;
import cn.com.poc.knowledge.dto.BizKnowledgeInfoDto;


public class BizKnowledgeInfoConvert {

    public static BizKnowledgeInfoEntity modelToEntity(BizKnowledgeInfoModel model) {
        BizKnowledgeInfoEntity entity = new BizKnowledgeInfoEntity();
        entity.setId(model.getId());
        entity.setKnowledgeName(model.getKnowledgeName());
        entity.setMemberId(model.getMemberId());
        entity.setKdIds(model.getKdIds());
        entity.setTrainStatus(model.getTrainStatus());
        entity.setKnowledgeDesc(model.getKnowledgeDesc());
        entity.setIsOpen(model.getIsOpen());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizKnowledgeInfoModel entityToModel(BizKnowledgeInfoEntity entity) {
        BizKnowledgeInfoModel model = new BizKnowledgeInfoModel();
        model.setId(entity.getId());
        model.setKnowledgeName(entity.getKnowledgeName());
        model.setMemberId(entity.getMemberId());
        model.setKdIds(entity.getKdIds());
        model.setTrainStatus(entity.getTrainStatus());
        model.setKnowledgeDesc(entity.getKnowledgeDesc());
        model.setIsOpen(entity.getIsOpen());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static BizKnowledgeInfoDto entityToDto(BizKnowledgeInfoEntity entity) {
        BizKnowledgeInfoDto dto = new BizKnowledgeInfoDto();
        dto.setId(entity.getId());
        dto.setKnowledgeName(entity.getKnowledgeName());
        dto.setMemberId(entity.getMemberId());
        dto.setIsOpen(entity.getIsOpen());
        dto.setKdIds(entity.getKdIds());
        dto.setTrainStatus(entity.getTrainStatus());
        dto.setDesc(entity.getKnowledgeDesc());
        dto.setCreatedTime(entity.getCreatedTime());
        return dto;
    }

    public static BizKnowledgeInfoEntity dtoToEntity(BizKnowledgeInfoDto dto) {
        BizKnowledgeInfoEntity entity = new BizKnowledgeInfoEntity();
        entity.setId(dto.getId());
        entity.setKnowledgeName(dto.getKnowledgeName());
        entity.setMemberId(dto.getMemberId());
        entity.setKdIds(dto.getKdIds());
        entity.setIsOpen(dto.getIsOpen());
        entity.setTrainStatus(dto.getTrainStatus());
        entity.setKnowledgeDesc(dto.getDesc());
        return entity;
    }
}