package cn.com.poc.message.service.impl;


import cn.com.poc.message.entity.KnowledgeTrainStatusMessage;
import cn.com.poc.message.entity.TrainKnowledgeMessage;
import cn.com.poc.message.service.KnowledgeProducerService;
import cn.com.poc.message.topic.KnowledgeTopic;
import cn.com.yict.framemax.tumbleweed.client.annotation.Producer;
import cn.com.yict.framemax.tumbleweed.constant.PublishPoint;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeProducerServiceImpl implements KnowledgeProducerService {


    /**
     * 训练知识库
     *
     * @param message
     * @return
     */
    @Override
    @Producer(topic = KnowledgeTopic.TRAIN_KNOWLEDGE, publishPoint = PublishPoint.PUBLISH_REAL_TIME)
    public TrainKnowledgeMessage trainKnowledge(TrainKnowledgeMessage message) {
        return message;
    }


    @Override
    @Producer(topic = KnowledgeTopic.TRAIN_STATUS, publishPoint = PublishPoint.PUBLISH_REAL_TIME)
    public KnowledgeTrainStatusMessage trainStatusUpdate(KnowledgeTrainStatusMessage knowledgeTrainStatusMessage) {
        return knowledgeTrainStatusMessage;
    }

    @Override
    @Producer(topic = KnowledgeTopic.KNOWLEDGE_INFO_STATUS_CHECK, publishPoint = PublishPoint.PUBLISH_REAL_TIME)
    public KnowledgeTrainStatusMessage knowledgeInfoStatusCheck(KnowledgeTrainStatusMessage knowledgeTrainStatusMessage) {
        return knowledgeTrainStatusMessage;
    }
}
