package cn.com.poc.support.login;


import cn.com.poc.common.constant.Member3ptLoginChannel;
import cn.com.poc.support.login.channel.bl.IBTLoginService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;


@Component
public class ThirdPlatformLoginServiceBuilder implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public ThirdPlatformLoginService getService(Member3ptLoginChannel channel) throws Exception {

        if (Member3ptLoginChannel.ibt.equals(channel)) {
            return applicationContext.getBean(IBTLoginService.class);
        }
        throw new I18nMessageException("exception/third.party.login.channel.abnormality");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
