//package cn.com.poc.support.register.channel.bl;
//
//
//import cn.com.blo.common.constant.BloCommonConstant;
//import cn.com.blo.common.constant.BloRedisKeyConstant;
//import cn.com.blo.common.service.CommonParamConfigService;
//import cn.com.blo.common.utils.NumberUtils;
//import cn.com.blo.support.register.ThirdPlatformRegisterService;
//import cn.com.blo.thirdParty.bl.api.BlMemberApi;
//import cn.com.blo.thirdParty.bl.domain.BlConfigEntity;
//import cn.com.blo.thirdParty.bl.request.BlMemberInfoRequest;
//import cn.com.blo.thirdParty.bl.request.BlMemberRequest;
//import cn.com.blo.thirdParty.bl.result.BlMemberAuthResult;
//import cn.com.blo.thirdParty.bl.result.BlMemberInfoResult;
//import cn.com.blo.thirdParty.bl.utils.BlAbstractHttpClient;
//import cn.com.blo.user.constant.Member3rdPartyRelationEnum;
//import cn.com.blo.user.dto.MemberInfoDto;
//import cn.com.blo.user.entity.BizMember3rdPartyRelationEntity;
//import cn.com.blo.user.model.BizMemberInfoModel;
//import cn.com.blo.user.service.BizMember3rdPartyRelationService;
//import cn.com.blo.user.service.BizMemberInfoService;
//import cn.com.gsst.marketing.tools.service.RedisService;
//import cn.com.yict.framemax.core.i18n.I18nMessageException;
//import org.apache.commons.lang3.StringUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.BeanUtils;
//import org.springframework.stereotype.Service;
//import org.springframework.util.Assert;
//
//import javax.annotation.Resource;
//import java.util.Optional;
//
///**
// * @author Focan.Zhong
// */
//@Service
//public class BlMobileRegisterService implements ThirdPlatformRegisterService {
//
//    private Logger logger = LoggerFactory.getLogger(this.getClass());
//
//    @Resource
//    private BizMemberInfoService bizMemberInfoService;
//
//    @Resource
//    private BizMember3rdPartyRelationService bizMember3rdPartyRelationService;
//
//    @Resource
//    private CommonParamConfigService commonParamConfigService;
//
//    @Resource
//    private RedisService redisService;
//
//    @Resource
//    private BlAbstractHttpClient blAbstractHttpClient;
//
//    private final static String DEFAULT_AVATAR_URL = "";
//
//    /**
//     * 第三方平台注册
//     *
//     * @param memberInfoDto
//     * @return
//     */
//    @Override
//    public MemberInfoDto doRegister(MemberInfoDto memberInfoDto) throws Exception {
//
//        //参数校验
//        check(memberInfoDto);
//
//        //查询配置
//        BlConfigEntity blThirdPartyConfig = commonParamConfigService.getBlThirdPartyConfig();
//        if (blThirdPartyConfig == null
//                || StringUtils.isBlank(blThirdPartyConfig.getAppKey())
//                || StringUtils.isBlank(blThirdPartyConfig.getAppSecret())
//                || StringUtils.isBlank(blThirdPartyConfig.getChannelIdWechat())
//                || StringUtils.isBlank(blThirdPartyConfig.getSysId())) {
//            throw new I18nMessageException("百联通开放平台配置异常！");
//        }
//
//        //调百联通手机号注册接口
//        BlMemberRequest regRequest = new BlMemberRequest();
//        regRequest.setMobile(memberInfoDto.getMobilePhone());
//        regRequest.setSmsCode(memberInfoDto.getSmsCode());
//        regRequest.setChannelId(blThirdPartyConfig.getChannelIdWechat());
//        regRequest.setSysid(blThirdPartyConfig.getSysId());
//        BlMemberAuthResult blMemberAuthResult = blAbstractHttpClient.doRequest(
//                blThirdPartyConfig.getAppKey(),
//                blThirdPartyConfig.getAppSecret(),
//                BlMemberApi.MOBILE_LOGIN_OR_REG, regRequest);
//
//        String encodeMemberId = blMemberAuthResult.getEncodeMemberId();
//        String memberToken = blMemberAuthResult.getMemberToken();
//
//
//        //查询奥拉会员信息
//        BlMemberInfoRequest memberInfoRequest = new BlMemberInfoRequest();
//        memberInfoRequest.setMemberToken(memberToken);
//        BlMemberInfoResult memberInfoResult = blAbstractHttpClient.doRequest(BlMemberApi.MEMBER_INFO, memberInfoRequest);
//
//        //保存会员信息
//        BizMemberInfoModel memberInfoModel = new BizMemberInfoModel();
//        memberInfoModel.setMemberLevel(memberInfoResult.getMemberLevel());
//        memberInfoModel.setMemberLevelName(memberInfoResult.getMemberLevelName());
//        memberInfoModel.setMobileMask(memberInfoResult.getMobileMask());
//        memberInfoModel.setRemainPoints(NumberUtils.defaultZeroIfNull(memberInfoResult.getRemainPoints()));
//        memberInfoModel.setCurrGrowthValue(memberInfoResult.getCurrGrowthValue());
//        memberInfoModel.setNextMemberLevel(memberInfoResult.getNextMemberLevel());
//        memberInfoModel.setNextMemberLevelName(memberInfoResult.getNextMemberLevelName());
//        memberInfoModel.setNextMemLevelGrowthVal(memberInfoResult.getNextMemLevelGrowthVal());
//
//        memberInfoModel.setNickName(memberInfoResult.getNickName());
//        memberInfoModel.setAvatarUrl(Optional.ofNullable(memberInfoResult.getAvatarUrl()).orElse(DEFAULT_AVATAR_URL));
//        memberInfoModel.setIsDeleted(BloCommonConstant.IsDeleted.N);
//
//        memberInfoModel = bizMemberInfoService.save(memberInfoModel);
//        Integer memberId = memberInfoModel.getMemberId();
//
//        //检查是否已有绑定关系
//        BizMember3rdPartyRelationEntity blRelationItem = bizMember3rdPartyRelationService.getByRelationIdAndPlatform(encodeMemberId, Member3rdPartyRelationEnum.BL_OPEN);
//        //绑定第三方关系表
//        if (blRelationItem == null) {
//            BizMember3rdPartyRelationEntity blRelation = new BizMember3rdPartyRelationEntity();
//            blRelation.setMemberId(memberId);
//            blRelation.setRelationId(encodeMemberId);
//            blRelation.setRelationPlatform(Member3rdPartyRelationEnum.BL_OPEN.name());
//            bizMember3rdPartyRelationService.save(blRelation);
//        }
//
//        //缓存会员token 有效期30天
//        String key = BloRedisKeyConstant.MEMBER_TOKEN + ":" + memberId;
//        logger.info("缓存会员token:key:[{}],memberToken:[{}]", key, memberToken);
//        //25天
//        redisService.set(key, memberToken, 2160000);
//
//        MemberInfoDto memberInfo = new MemberInfoDto();
//        BeanUtils.copyProperties(memberInfoModel, memberInfo);
//        memberInfo.setBlEncodeMemberId(encodeMemberId);
//        memberInfo.setBlMemberToken(memberToken);
//        return memberInfo;
//    }
//
//    /**
//     * 检查参数
//     *
//     * @param memberInfoDto
//     */
//    private void check(MemberInfoDto memberInfoDto) {
//        Assert.notNull(memberInfoDto);
//        Assert.notNull(memberInfoDto.getMobilePhone());
//        Assert.notNull(memberInfoDto.getSmsCode());
//    }
//
//}
//
//
//
