//package cn.com.poc.support.register.channel.bl;
//
//
//import cn.com.blo.common.constant.BloCommonConstant;
//import cn.com.blo.common.constant.BloRedisKeyConstant;
//import cn.com.blo.common.service.CommonParamConfigService;
//import cn.com.blo.common.utils.NumberUtils;
//import cn.com.blo.common.utils.StringUtils;
//import cn.com.blo.support.register.ThirdPlatformRegisterService;
//import cn.com.blo.thirdParty.bl.api.BlMemberApi;
//import cn.com.blo.thirdParty.bl.domain.BlConfigEntity;
//import cn.com.blo.thirdParty.bl.request.BlMemberInfoRequest;
//import cn.com.blo.thirdParty.bl.request.BlMemberRequest;
//import cn.com.blo.thirdParty.bl.result.BlMemberAuthResult;
//import cn.com.blo.thirdParty.bl.result.BlMemberInfoResult;
//import cn.com.blo.thirdParty.bl.utils.BlAbstractHttpClient;
//import cn.com.blo.user.constant.Member3rdPartyRelationEnum;
//import cn.com.blo.user.dto.MemberInfoDto;
//import cn.com.blo.user.entity.BizMember3rdPartyRelationEntity;
//import cn.com.blo.user.model.BizMemberInfoModel;
//import cn.com.blo.user.service.BizMember3rdPartyRelationService;
//import cn.com.blo.user.service.BizMemberInfoService;
//import cn.com.blo.wx.constant.BloWxAppSceneCodeConstant;
//import cn.com.blo.wx.entity.BizWxAppInfo;
//import cn.com.blo.wx.service.BizWxAppInfoService;
//import cn.com.gsst.marketing.tools.service.RedisService;
//import cn.com.yict.framemax.core.i18n.I18nMessageException;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.BeanUtils;
//import org.springframework.stereotype.Service;
//import org.springframework.util.Assert;
//
//import javax.annotation.Resource;
//import java.util.Optional;
//
//@Service
//public class BlWxMiniRegisterService implements ThirdPlatformRegisterService {
//
//    private Logger logger = LoggerFactory.getLogger(this.getClass());
//
//    @Resource
//    private BizMemberInfoService bizMemberInfoService;
//
//    @Resource
//    private BizMember3rdPartyRelationService bizMember3rdPartyRelationService;
//
//    @Resource
//    private BizWxAppInfoService bizWxAppInfoService;
//
//    @Resource
//    private CommonParamConfigService commonParamConfigService;
//
//    @Resource
//    private RedisService redisService;
//
//    @Resource
//    private BlAbstractHttpClient blAbstractHttpClient;
//
//    private final static String DEFAULT_AVATAR_URL = "https://blo-prod.obs.cn-east-3.myhuaweicloud.com/mini/icon/mini-dafault-avatar.png";
//
//
//    /**
//     * 第三方平台注册
//     *
//     * @param memberInfoDto
//     * @return
//     */
//    @Override
//    public MemberInfoDto doRegister(MemberInfoDto memberInfoDto) throws Exception {
//
//        //参数校验
//        check(memberInfoDto);
//
//        BizWxAppInfo wxAppInfo = bizWxAppInfoService.getBySceneCode(BloWxAppSceneCodeConstant.BLO_MINI);
//        if (wxAppInfo == null) {
//            throw new I18nMessageException("获取小程序信息异常！请检查配置是否正确！");
//        }
//
//        //查询配置
//        BlConfigEntity blThirdPartyConfig = commonParamConfigService.getBlThirdPartyConfig();
//        if (blThirdPartyConfig == null
//                || StringUtils.isBlank(blThirdPartyConfig.getAppKey())
//                || StringUtils.isBlank(blThirdPartyConfig.getAppSecret())
//                || StringUtils.isBlank(blThirdPartyConfig.getThirdPartyIdTypeMini())
//                || StringUtils.isBlank(blThirdPartyConfig.getSysId())) {
//            throw new I18nMessageException("百联通开放平台配置异常！");
//        }
//
//        //调百联小程序注册接口
//        BlMemberRequest regRequest = new BlMemberRequest();
//        regRequest.setThirdPartyIdType(blThirdPartyConfig.getThirdPartyIdTypeMini());
//        regRequest.setWxAppId(wxAppInfo.getAppId());
//        regRequest.setWxLoginCode(memberInfoDto.getAuthorizeCode());
//        regRequest.setUserInfoEncryptedData(memberInfoDto.getUserInfoEncryptedData());
//        regRequest.setWxGetUserInfoIv(memberInfoDto.getWxGetUserInfoIv());
//        regRequest.setPhoneNumberEncryptedData(memberInfoDto.getPhoneNumberEncryptedData());
//        regRequest.setWxGetPhoneNumberIv(memberInfoDto.getWxGetPhoneNumberIv());
//        regRequest.setSysid(blThirdPartyConfig.getSysId());
//        regRequest.setAdChannel("CRM_HZALTF");
//        regRequest.setBatchid("MD1627875917460");
//        regRequest.setComBizId(blThirdPartyConfig.getOperationTypeId());
//        regRequest.setShopCode(blThirdPartyConfig.getShopCode());
//        if (StringUtils.isNotBlank(blThirdPartyConfig.getMemberRegAdChannel())
//                && StringUtils.isNotBlank(blThirdPartyConfig.getMemberRegBatchId())) {
//            regRequest.setAdChannel(blThirdPartyConfig.getMemberRegAdChannel());
//            regRequest.setBatchid(blThirdPartyConfig.getMemberRegBatchId());
//        }
//
//        BlMemberAuthResult blMemberAuthResult = blAbstractHttpClient.doRequest(blThirdPartyConfig.getAppKey(),
//                blThirdPartyConfig.getAppSecret(), BlMemberApi.MINI_AUTH, regRequest);
//
//        String encodeMemberId = blMemberAuthResult.getEncodeMemberId();
//        String memberToken = blMemberAuthResult.getMemberToken();
//        BlMemberAuthResult.BlWxUserInfo userInfo = blMemberAuthResult.getUserInfo();
//
//        //查询百联会员信息
//        BlMemberInfoRequest memberInfoRequest = new BlMemberInfoRequest();
//        memberInfoRequest.setMemberToken(memberToken);
//        BlMemberInfoResult memberInfoResult = blAbstractHttpClient.doRequest(BlMemberApi.MEMBER_INFO, memberInfoRequest);
//
//        //检查是否已有绑定关系
//        BizMember3rdPartyRelationEntity blRelationItem = bizMember3rdPartyRelationService.getByRelationIdAndPlatform(encodeMemberId, Member3rdPartyRelationEnum.BL_OPEN);
//
//        BizMemberInfoModel memberInfoModel = null;
//        Integer memberId = null;
//        if (blRelationItem != null) {
//            //已存在会员信息，则更新
//            memberId = blRelationItem.getMemberId();
//            memberInfoModel = bizMemberInfoService.get(memberId);
//            memberInfoModel.setMemberLevel(memberInfoResult.getMemberLevel());
//            memberInfoModel.setMemberLevelName(memberInfoResult.getMemberLevelName());
//            memberInfoModel.setMobilePhone(memberInfoResult.getMobileMask());
//            memberInfoModel.setMobileMask(memberInfoResult.getMobileMask());
//            memberInfoModel.setRemainPoints(NumberUtils.defaultZeroIfNull(memberInfoResult.getRemainPoints()));
//            memberInfoModel.setCurrGrowthValue(memberInfoResult.getCurrGrowthValue());
//            memberInfoModel.setNextMemberLevel(memberInfoResult.getNextMemberLevel());
//            memberInfoModel.setNextMemberLevelName(memberInfoResult.getNextMemberLevelName());
//            memberInfoModel.setNextMemLevelGrowthVal(memberInfoResult.getNextMemLevelGrowthVal());
//            memberInfoModel.setAvatarUrl(Optional.ofNullable(memberInfoResult.getAvatarUrl()).orElse(DEFAULT_AVATAR_URL));
//            memberInfoModel = bizMemberInfoService.save(memberInfoModel);
//
//        } else {
//            //保存会员信息
//            memberInfoModel = new BizMemberInfoModel();
//            memberInfoModel.setMemberLevel(memberInfoResult.getMemberLevel());
//            memberInfoModel.setMemberLevelName(memberInfoResult.getMemberLevelName());
//            memberInfoModel.setMobilePhone(memberInfoResult.getMobileMask());
//            memberInfoModel.setMobileMask(memberInfoResult.getMobileMask());
//            memberInfoModel.setRemainPoints(NumberUtils.defaultZeroIfNull(memberInfoResult.getRemainPoints()));
//            memberInfoModel.setCurrGrowthValue(memberInfoResult.getCurrGrowthValue());
//            memberInfoModel.setNextMemberLevel(memberInfoResult.getNextMemberLevel());
//            memberInfoModel.setNextMemberLevelName(memberInfoResult.getNextMemberLevelName());
//            memberInfoModel.setNextMemLevelGrowthVal(memberInfoResult.getNextMemLevelGrowthVal());
//
//            memberInfoModel.setNickName(memberInfoResult.getNickName());
//            memberInfoModel.setAvatarUrl(DEFAULT_AVATAR_URL);
//            memberInfoModel.setIsDeleted(BloCommonConstant.IsDeleted.N);
//
//            memberInfoModel = bizMemberInfoService.save(memberInfoModel);
//            memberId = memberInfoModel.getMemberId();
//
//            BizMember3rdPartyRelationEntity blRelation = new BizMember3rdPartyRelationEntity();
//            blRelation.setMemberId(memberId);
//            blRelation.setRelationId(encodeMemberId);
//            blRelation.setRelationPlatform(Member3rdPartyRelationEnum.BL_OPEN.name());
//            bizMember3rdPartyRelationService.save(blRelation);
//        }
//
//        if (userInfo != null) {
//            String openId = userInfo.getOpenId();
//            String unionId = userInfo.getUnionId();
//            if (StringUtils.isNotBlank(openId)) {
//                BizMember3rdPartyRelationEntity wxMiniRelationItem = bizMember3rdPartyRelationService.getByRelationIdAndPlatform(openId, Member3rdPartyRelationEnum.WX_MINI);
//                if (wxMiniRelationItem == null) {
//                    BizMember3rdPartyRelationEntity openIdRelation = new BizMember3rdPartyRelationEntity();
//                    openIdRelation.setMemberId(memberId);
//                    openIdRelation.setRelationId(openId);
//                    openIdRelation.setRelationPlatform(Member3rdPartyRelationEnum.WX_MINI.name());
//                    bizMember3rdPartyRelationService.save(openIdRelation);
//                }
//            }
//            if (StringUtils.isNotBlank(unionId)) {
//                BizMember3rdPartyRelationEntity wxOpenRelationItem = bizMember3rdPartyRelationService.getByRelationIdAndPlatform(openId, Member3rdPartyRelationEnum.WX_MINI);
//                if (wxOpenRelationItem == null) {
//                    BizMember3rdPartyRelationEntity unionIdRelation = new BizMember3rdPartyRelationEntity();
//                    unionIdRelation.setMemberId(memberId);
//                    unionIdRelation.setRelationId(unionId);
//                    unionIdRelation.setRelationPlatform(Member3rdPartyRelationEnum.WX_OPEN.name());
//                    bizMember3rdPartyRelationService.save(unionIdRelation);
//                }
//            }
//        }
//
//        //缓存会员token 有效期30天
//        String key = BloRedisKeyConstant.MEMBER_TOKEN + ":" + memberId;
//        logger.info("缓存会员token:key:[{}],memberToken:[{}]", key, memberToken);
//        //25天
//        redisService.set(key, memberToken, 2160000);
//
//        MemberInfoDto memberInfo = new MemberInfoDto();
//        BeanUtils.copyProperties(memberInfoModel, memberInfo);
//        memberInfo.setBlEncodeMemberId(encodeMemberId);
//        memberInfo.setBlMemberToken(memberToken);
//        return memberInfo;
//    }
//
//    /**
//     * 检查参数
//     *
//     * @param memberInfoDto
//     */
//    private void check(MemberInfoDto memberInfoDto) {
//        Assert.notNull(memberInfoDto);
//        Assert.notNull(memberInfoDto.getAuthorizeCode());
//        Assert.notNull(memberInfoDto.getUserInfoEncryptedData());
//        Assert.notNull(memberInfoDto.getWxGetUserInfoIv());
//        Assert.notNull(memberInfoDto.getPhoneNumberEncryptedData());
//        Assert.notNull(memberInfoDto.getWxGetPhoneNumberIv());
//    }
//}
//
//
//
