package cn.com.poc.thirdparty.resource.baidu.service.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.thirdparty.resource.baidu.api.BaiduTransApi;
import cn.com.poc.thirdparty.resource.baidu.constants.BaiduTransTypeConstants;
import cn.com.poc.thirdparty.resource.baidu.entity.response.BaiduTextTransResponse;
import cn.com.poc.thirdparty.resource.baidu.entity.result.textTrans.BaiduTextTransResult;
import cn.com.poc.thirdparty.resource.baidu.service.BaiduTokenService;
import cn.com.poc.thirdparty.resource.baidu.service.BaiduTransService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2023/11/28
 **/
@Service
public class BaiduTransServiceImpl implements BaiduTransService {

    final private Logger logger = LoggerFactory.getLogger(BaiduTransService.class);

    @Resource
    private BaiduTokenService baiduTokenService;

    @Resource
    private BaiduTransApi baiduTransApi;

    @Override
    public String textTrans(String sourceText, String sourceLanguage, String targetLanguage) {
        Assert.notBlank(sourceText);
        Assert.notBlank(targetLanguage);
        Assert.isTrue(BaiduTransTypeConstants.Utils.isExist(targetLanguage));

        sourceText = sourceText.replaceAll(StringUtils.LF, StringUtils.SPACE);
        String token = baiduTokenService.getToken();
        BaiduTextTransResponse response = new BaiduTextTransResponse();
        response.setQ(sourceText);
        response.setFrom(StringUtils.isNoneBlank(sourceLanguage) ? sourceLanguage : "auto");
        response.setTo(targetLanguage);
        BaiduTextTransResult baiduTextTransResult = baiduTransApi.textTrans(token, response);
        if (baiduTextTransResult.getError_code() != null) {
            logger.warn("baidu translation error_code:{}, error_msg:{}", baiduTextTransResult.getError_code(), baiduTextTransResult.getError_msg());
            throw new I18nMessageException("exception/training.exception.please.contact.the.administrator");
        }
        return baiduTextTransResult.getResult().getTrans_result().get(0).getDst();
    }

    @Override
    public BaiduTextTransResult textTransDict(String sourceText, String sourceLanguage, String targetLanguage) {
        Assert.notBlank(sourceText);
        Assert.notBlank(targetLanguage);
        Assert.isTrue(BaiduTransTypeConstants.Utils.isExist(sourceLanguage));

        sourceText = sourceText.replaceAll(StringUtils.LF, StringUtils.SPACE);
        String token = baiduTokenService.getToken();
        BaiduTextTransResponse response = new BaiduTextTransResponse();
        response.setQ(sourceText);
        response.setFrom(StringUtils.isNoneBlank(sourceLanguage) ? sourceLanguage : "auto");
        response.setTo(targetLanguage);
        BaiduTextTransResult baiduTextTransResult = baiduTransApi.textTrans(token, response);
        if (baiduTextTransResult.getError_code() != null) {
            logger.warn("baidu translation error_code:{}, error_msg:{}", baiduTextTransResult.getError_code(), baiduTextTransResult.getError_msg());
            throw new I18nMessageException("exception/training.exception.please.contact.the.administrator");
        }
        return baiduTextTransResult;
    }
}
