package cn.com.poc.thirdparty.resource.demand.ai.aggregate.impl;

import cn.com.poc.thirdparty.resource.demand.ai.aggregate.AIDialogueService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.member.service.DemandAuthService;
import cn.com.poc.support.dgTools.DgtoolsAbstractHttpClient;
import cn.com.poc.thirdparty.resource.demand.ai.common.DgtoolsApiConstants;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2023/5/24
 **/

@Component
public class AIDialogueServiceImpl implements AIDialogueService {
    private final String POST = "POST";

    @Value("${dgtools.domain.url}")
    private String DOMAIN_URL;

    @Value(value = "${large-model.apikey}")
    private String API_KEY;

    @Resource
    private DemandAuthService demandAuthService;

    @Resource
    private DgtoolsAbstractHttpClient dgToolsAbstractHttpClient;

    @Override
    public BufferedReader polyStream(LargeModelResponse largeResponse) throws Exception {
        //获取one-api key
        largeResponse.setStream(true);
        LargeModelDemandResponse response = new LargeModelDemandResponse();
        response.setApiKey(API_KEY);
        response.setLargeResponse(largeResponse);
        return largeModelStream(response);
    }

    @Override
    public LargeModelDemandResult poly(LargeModelResponse largeResponse) {
        largeResponse.setStream(false);
        LargeModelDemandResponse response = new LargeModelDemandResponse();
        response.setApiKey(API_KEY);
        response.setLargeResponse(largeResponse);
        return largeModelRequest(response);
    }

    @Override
    public FunctionCallResult functionCall(FunctionCallResponse response) {
        String url = DgtoolsApiConstants.DgtoolsAI.FUNCTION_CALL;
        response.setApiKey(API_KEY);
        List<Header> headers = new ArrayList<Header>() {{
            add(DgtoolsApiConstants.JSON_HEADER);
            add(DgtoolsApiConstants.AI_HEADER);
            add(new BasicHeader(DgtoolsApiConstants.HEADER_X_PLATFORM_AUTHORIZATION, demandAuthService.getToken()));
        }};
        return dgToolsAbstractHttpClient.doRequest(url, response, headers);
    }

    private BufferedReader largeModelStream(LargeModelDemandResponse request) throws IOException {
        String jsonBody = dgToolsAbstractHttpClient.buildJson(request);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = httpClient.execute(RequestBuilder.create(POST)
                .setUri(DOMAIN_URL + DgtoolsApiConstants.BASE_URL + DgtoolsApiConstants.DgtoolsAI.LARGE_MODEL)
                .addHeader(DgtoolsApiConstants.JSON_HEADER)
                .addHeader(DgtoolsApiConstants.AI_HEADER)
                .addHeader(new BasicHeader(DgtoolsApiConstants.HEADER_X_PLATFORM_AUTHORIZATION, demandAuthService.getToken()))
                .setEntity(new StringEntity(jsonBody, StandardCharsets.UTF_8))
                .build()
        );
        InputStream inputStream = httpResponse.getEntity().getContent();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return bufferedReader;
    }

    private LargeModelDemandResult largeModelRequest(LargeModelDemandResponse request) {
        String url = DgtoolsApiConstants.DgtoolsAI.LARGE_MODEL;
        List<Header> headers = new ArrayList<Header>() {{
            add(DgtoolsApiConstants.JSON_HEADER);
            add(DgtoolsApiConstants.AI_HEADER);
            add(new BasicHeader(DgtoolsApiConstants.HEADER_X_PLATFORM_AUTHORIZATION, demandAuthService.getToken()));
        }};
            return dgToolsAbstractHttpClient.doRequest(url, request, headers);
    }


}
