package cn.com.poc.thirdparty.resource.demand.ai.entity.generations;

import cn.com.poc.support.dgTools.request.AbstractRequest;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: Zackery
 * @Description:
 * @Date: 2024/4/10 15:35
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaiduAISailsImage2TextRequest extends AbstractRequest<BaiduAISailsImage2TextResult> implements Serializable {

    /**
     * 请求信息
     * 是否必填：是
     */
    private String prompt;

    /**
     * 图片数据，说明：
     * base64编码，要求base64编码后大小不超过4M，最短边至少15px，最长边最大4096px，支持jpg/png/bmp格式，注意请去掉头部
     * 是否必填：是
     */
    private String image;

    /**
     * 是否以流式接口的形式返回数据，默认false
     * 是否必填：否
     */
    private Boolean stream;

    /**
     * 说明：
     * （1）较高的数值会使输出更加随机，而较低的数值会使其更加集中和确定
     * （2）范围 (0, 1.0]，不能为0
     * 是否必填：否
     */
    private Float temperature;

    /**
     * Top-K 采样参数，在每轮token生成时，保留k个概率最高的token作为候选。说明：
     * （1）影响输出文本的多样性，取值越大，生成文本的多样性越强
     * （2）取值范围：正整数
     * 是否必填：否
     */
    private Integer topK;

    /**
     * 说明：
     * （1）影响输出文本的多样性，取值越大，生成文本的多样性越强
     * （2）取值范围 [0, 1.0]
     * 是否必填：否
     */
    private Float topP;

    /**
     * 通过对已生成的token增加惩罚，减少重复生成的现象。说明：
     * （1）值越大表示惩罚越大
     * （2）取值范围：[1.0, 2.0]
     * 是否必填：否
     */
    private Float penaltyScore;

    /**
     * 生成停止标识。当模型生成结果以stop中某个元素结尾时，停止文本生成。说明：
     * （1）每个元素长度不超过20字符。
     * （2）最多4个元素
     * 是否必填：否
     */
    private List<String> stop;

    /**
     * 表示最终用户的唯一标识符
     * 是否必填：否
     */
    private String userId;

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Boolean getStream() {
        return stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public Float getTemperature() {
        return temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Integer getTopK() {
        return topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Float getTopP() {
        return topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Float getPenaltyScore() {
        return penaltyScore;
    }

    public void setPenaltyScore(Float penaltyScore) {
        this.penaltyScore = penaltyScore;
    }

    public List<String> getStop() {
        return stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getMethod() throws Exception {
        return null;
    }

}
