package cn.com.poc.thirdparty.resource.demand.ai.entity.generations;

import cn.com.poc.support.dgTools.request.AbstractRequest;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

/**
 * @Author: Zackery
 * @Description: 百度千帆大模型文生图响应请求
 * @Date: 2024/4/9 15:05
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaiduAISailsText2ImageRequest extends AbstractRequest<BaiduAISailsText2ImageResult> implements Serializable {

    /**
     * 提示词，即用户希望图片包含的元素。长度限制为1024字符，建议中文或者英文单词总数量不超过150个
     * 是否必填：是
     */
    private String prompt;

    /**
     * 反向提示词，即用户希望图片不包含的元素。长度限制为1024字符，建议中文或者英文单词总数量不超过150个
     * 是否必填：否
     */
    private String negativePrompt;

    /**
     * 生成图片长宽，默认值 1024x1024，取值范围如下：
     * · 适用头像： ["768x768", "1024x1024", "1536x1536", "2048x2048"]
     * · 适用文章配图 ：["1024x768", "2048x1536"]
     * · 适用海报传单：["768x1024", "1536x2048"]
     * · 适用电脑壁纸：["1024x576", "2048x1152"]
     * · 适用海报传单：["576x1024", "1152x2048"]
     * 是否必填：否
     */
    private String size;

    /**
     * 生成图片数量，说明：
     * · 默认值为1
     * · 取值范围为1-4
     * · 单次生成的图片较多及请求较频繁可能导致请求超时
     * 是否必填：否
     */
    private Integer n;

    /**
     * 迭代轮次，说明：
     * · 默认值为20
     * · 取值范围为10-50
     * 是否必填：否
     */
    private Integer steps;

    /**
     * 	采样方式，默认值：Euler a，可选值如下(释义参考)：
     * · Euler
     * · Euler a
     * · DPM++ 2M
     * · DPM++ 2M Karras
     * · LMS Karras
     * · DPM++ SDE
     * · DPM++ SDE Karras
     * · DPM2 a Karras
     * · Heun
     * · DPM++ 2M SDE
     * · DPM++ 2M SDE Karras
     * · DPM2
     * · DPM2 Karras
     * · DPM2 a
     * · LMS
     * 是否必填：否
     */
    private String samplerIndex;

    /**
     * 随机种子，说明：
     * · 不设置时，自动生成随机数
     * · 取值范围 [0, 4294967295]
     * 是否必填：否
     */
    private Long seed;

    /**
     * 提示词相关性，说明：默认值为5，取值范围0-30
     * 是否必填：否
     */
    private Float cfgCcale;

    /**
     * 生成风格。说明：
     * （1）可选值：
     * · Base：基础风格
     * · 3D Model：3D模型
     * · Analog Film：模拟胶片
     * · Anime：动漫
     * · Cinematic：电影
     * · Comic Book：漫画
     * · Craft Clay：工艺黏土
     * · Digital Art：数字艺术
     * · Enhance：增强
     * · Fantasy Art：幻想艺术
     * · Isometric：等距风格
     * · Line Art：线条艺术
     * · Lowpoly：低多边形
     * · Neonpunk：霓虹朋克
     * · Origami：折纸
     * · Photographic：摄影
     * · Pixel Art：像素艺术
     * · Texture：纹理
     * （2）默认值为Base
     * 是否必填：否
     */
    private String style;

    /**
     * 表示最终用户的唯一标识符
     * 是否必填：否
     */
    private String userId;

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getNegativePrompt() {
        return negativePrompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Integer getN() {
        return n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Integer getSteps() {
        return steps;
    }

    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public String getSamplerIndex() {
        return samplerIndex;
    }

    public void setSamplerIndex(String samplerIndex) {
        this.samplerIndex = samplerIndex;
    }

    public Long getSeed() {
        return seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public Float getCfgCcale() {
        return cfgCcale;
    }

    public void setCfgCcale(Float cfgCcale) {
        this.cfgCcale = cfgCcale;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getMethod() throws Exception {
        return null;
    }

    @Override
    public String toString() {
        return "BaiduAISailsText2ImageRequest{" +
                "prompt='" + prompt + '\'' +
                ", negativePrompt='" + negativePrompt + '\'' +
                ", size='" + size + '\'' +
                ", n=" + n +
                ", steps=" + steps +
                ", samplerIndex='" + samplerIndex + '\'' +
                ", seed=" + seed +
                ", cfgCcale=" + cfgCcale +
                ", style='" + style + '\'' +
                ", userId='" + userId + '\'' +
                '}';
    }
}
