package cn.com.poc.thirdparty.resource.demand.ai.entity.generations;

import cn.com.poc.thirdparty.resource.demand.ai.entity.BaiduErrorResult;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: Zackery
 * @Description: 百度千帆大模型文生图响应结果
 * @Date: 2024/4/9 12:21
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaiduAISailsText2ImageResult extends BaiduErrorResult implements Serializable {

    /**
     * 请求的id
     */
    private String id;

    /**
     * 回包类型。image：图像生成返回
     */
    private String object;

    /**
     * 时间戳
     */
    private Integer created;

    /**
     * 生成图片结果
     */
    private List<BaiduAISailsText2ImageDataItem> data;

    /**
     * token统计信息，token数 = 汉字数+单词数*1.3 （仅为估算逻辑）
     */
    private BaiduAISailsText2ImageUsage usage;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Integer getCreated() {
        return created;
    }

    public void setCreated(Integer created) {
        this.created = created;
    }

    public List<BaiduAISailsText2ImageDataItem> getData() {
        return data;
    }

    public void setData(List<BaiduAISailsText2ImageDataItem> data) {
        this.data = data;
    }

    public BaiduAISailsText2ImageUsage getUsage() {
        return usage;
    }

    public void setUsage(BaiduAISailsText2ImageUsage usage) {
        this.usage = usage;
    }

}
