package cn.com.poc.thirdparty.resource.demand.ai.function.long_memory;

import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.SpringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetLongMemory {

    public static List<LongMemoryEntity> get(String key) {
        RedisService redisService = SpringUtils.getBean(RedisService.class);
        List<LongMemoryEntity> result = new ArrayList<>();
        // 查询用户相关信息（什么内容都可以）
        String contentKey = SetLongMemoryConstants.REDIS_PREFIX + key + ":" + BlContext.getCurrentUserNotException().getUserId().toString();
        Map<Object, Object> map = redisService.hmget(contentKey);
        Set<Object> keySet = map.keySet();

        for (Object mapKey : keySet) {
            LongMemoryEntity entity = new LongMemoryEntity();
            entity.setContent(map.get(mapKey).toString());
            entity.setTimestamp(mapKey.toString());
            result.add(entity);
        }
        return result;
    }

}
