package cn.com.poc.thirdparty.resource.demand.clickhouse.service.impl;

import cn.com.poc.support.dgTools.DgtoolsAbstractHttpClient;
import cn.com.poc.thirdparty.resource.demand.ai.common.DgtoolsApiConstants;
import cn.com.poc.thirdparty.resource.demand.clickhouse.entity.WebBrowseHarvestEntity;
import cn.com.poc.thirdparty.resource.demand.clickhouse.service.DataReportService;
import cn.com.poc.thirdparty.resource.demand.member.service.DemandAuthService;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class DataReportServiceImpl implements DataReportService {

    @Value("${dgtools.domain.url}")
    private String DOMAIN_URL;

    @Resource
    private DemandAuthService demandAuthService;

    @Resource
    private DgtoolsAbstractHttpClient dgToolsAbstractHttpClient;

    @Override
    public void webBrowseHarvest(WebBrowseHarvestEntity webBrowseHarvest) {
        dataReport(webBrowseHarvest);
    }

    private void dataReport(WebBrowseHarvestEntity request) {
        List<Header> headers = new ArrayList<Header>() {{
            add(DgtoolsApiConstants.JSON_HEADER);
            add(DgtoolsApiConstants.CKHOUSE_HEADER);
            add(new BasicHeader(DgtoolsApiConstants.HEADER_X_PLATFORM_AUTHORIZATION, demandAuthService.getToken()));
        }};
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiConstants.ClickHouse.WEB_BROWSE_HARVEST_REPORT, request, headers);
    }

}
