package cn.com.poc.user.convert;

import cn.com.poc.user.dto.MemberInfoDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.model.BizMemberInfoModel;

/**
 * @Author：Roger Wu
 * @name：MemberInfoConvert
 * @Date：2024-07-25 11:15
 */
public class MemberInfoConvert {
    public static BizMemberInfoModel convertEntity2Model(MemberInfoEntity memberInfoEntity) {
        if (memberInfoEntity == null) {
            return null;
        }
        BizMemberInfoModel bizMemberInfoModel = new BizMemberInfoModel();
        bizMemberInfoModel.setMemberId(memberInfoEntity.getMemberId());
        bizMemberInfoModel.setAccount(memberInfoEntity.getAccount());
        bizMemberInfoModel.setNickName(memberInfoEntity.getNickName());
        bizMemberInfoModel.setAvatarUrl(memberInfoEntity.getAvatarUrl());
        bizMemberInfoModel.setMobilePhone(memberInfoEntity.getMobilePhone());
        bizMemberInfoModel.setEmail(memberInfoEntity.getEmail());
        bizMemberInfoModel.setLastLoginTime(memberInfoEntity.getLastLoginTime());
        bizMemberInfoModel.setShareCode(memberInfoEntity.getShareCode());
        bizMemberInfoModel.setRemark(memberInfoEntity.getRemark());
        return bizMemberInfoModel;
    }

    public static MemberInfoEntity convertModel2Entity(BizMemberInfoModel bizMemberInfoModel) {
        if (bizMemberInfoModel == null) {
            return null;
        }
        MemberInfoEntity memberInfoEntity = new MemberInfoEntity();
        memberInfoEntity.setMemberId(bizMemberInfoModel.getMemberId());
        memberInfoEntity.setAccount(bizMemberInfoModel.getAccount());
        memberInfoEntity.setNickName(bizMemberInfoModel.getNickName());
        memberInfoEntity.setAvatarUrl(bizMemberInfoModel.getAvatarUrl());
        memberInfoEntity.setMobilePhone(bizMemberInfoModel.getMobilePhone());
        memberInfoEntity.setEmail(bizMemberInfoModel.getEmail());
        memberInfoEntity.setLastLoginTime(bizMemberInfoModel.getLastLoginTime());
        memberInfoEntity.setRemark(bizMemberInfoModel.getRemark());
        memberInfoEntity.setShareCode(bizMemberInfoModel.getShareCode());
        return memberInfoEntity;
    }

    public static MemberInfoDto converEntity2Dto(MemberInfoEntity memberInfoEntity) {
        if (memberInfoEntity == null) {
            return null;
        }
        MemberInfoDto memberInfoDto = new MemberInfoDto();
        memberInfoDto.setMemberId(memberInfoEntity.getMemberId());
        memberInfoDto.setAccount(memberInfoEntity.getAccount());
        memberInfoDto.setNickName(memberInfoEntity.getNickName());
        memberInfoDto.setAvatarUrl(memberInfoEntity.getAvatarUrl());
        memberInfoDto.setMobilePhone(memberInfoEntity.getMobilePhone());
        memberInfoDto.setEmail(memberInfoEntity.getEmail());
        memberInfoDto.setRemark(memberInfoEntity.getRemark());
        memberInfoDto.setLastLoginTime(memberInfoEntity.getLastLoginTime());
        memberInfoDto.setShareCode(memberInfoEntity.getShareCode());
        memberInfoDto.setModelState(memberInfoEntity.getModelState());
        return memberInfoDto;
    }

    public static MemberInfoEntity convertDto2Entity(MemberInfoDto memberInfoDto) {
        if (memberInfoDto == null) {
            return null;
        }
        MemberInfoEntity memberInfoEntity = new MemberInfoEntity();
        memberInfoEntity.setMemberId(memberInfoDto.getMemberId());
        memberInfoEntity.setAccount(memberInfoDto.getAccount());
        memberInfoEntity.setNickName(memberInfoDto.getNickName());
        memberInfoEntity.setAvatarUrl(memberInfoDto.getAvatarUrl());
        memberInfoEntity.setMobilePhone(memberInfoDto.getMobilePhone());
        memberInfoEntity.setEmail(memberInfoDto.getEmail());
        memberInfoEntity.setRemark(memberInfoDto.getRemark());
        memberInfoEntity.setLastLoginTime(memberInfoDto.getLastLoginTime());
        memberInfoEntity.setShareCode(memberInfoDto.getShareCode());
        memberInfoEntity.setModelState(memberInfoDto.getModelState());
        return memberInfoEntity;
    }
}