package cn.com.poc.user.model;

import java.io.Serializable;
import java.util.Date;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_member_info
 * 用户信息表
 */
@Entity
@Table(name = "biz_member_info")
@DynamicInsert
@DynamicUpdate
public class BizMemberInfoModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * member_id
     * 会员id
     */
    private java.lang.Integer memberId;

    @Column(name = "member_id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Integer getMemberId() {
        return this.memberId;
    }

    public void setMemberId(java.lang.Integer memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * account
     * 用户账号
     */
    private java.lang.String account;

    @Column(name = "account", length = 50)
    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
        super.addValidField("account");
    }


    /**
     * nick_name
     * 用户昵称
     */
    private java.lang.String nickName;

    @Column(name = "nick_name", length = 50)
    public java.lang.String getNickName() {
        return this.nickName;
    }

    public void setNickName(java.lang.String nickName) {
        this.nickName = nickName;
        super.addValidField("nickName");
    }


    /**
     * avatar_url
     * 用户头像图片的 URL
     */
    private java.lang.String avatarUrl;

    @Column(name = "avatar_url", length = 255)
    public java.lang.String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(java.lang.String avatarUrl) {
        this.avatarUrl = avatarUrl;
        super.addValidField("avatarUrl");
    }


    /**
     * mobile_phone
     * 用户手机号
     */
    private java.lang.String mobilePhone;

    @Column(name = "mobile_phone", length = 50)
    public java.lang.String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(java.lang.String mobilePhone) {
        this.mobilePhone = mobilePhone;
        super.addValidField("mobilePhone");
    }

    /**
     * email
     * 用户邮箱
     */
    private java.lang.String email;

    @Column(name = "email", length = 150)
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
        super.addValidField("email");
    }

    /**
     * is_deleted
     * 是否删除 Y-是 N-否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 50)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * remark
     * 备注
     */
    private java.lang.String remark;

    @Column(name = "remark", length = 255)
    public java.lang.String getRemark() {
        return this.remark;
    }

    public void setRemark(java.lang.String remark) {
        this.remark = remark;
        super.addValidField("remark");
    }


    /**
     * last_login_time
     * 用户账号
     */
    private java.util.Date lastLoginTime;

    @Column(name = "last_login_time", length = 50)
    public Date getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        super.addValidField("lastLoginTime");
    }


    /**
     * share_code
     * 分享码
     */
    private java.lang.String shareCode;

    @Column(name = "share_code", length = 50)
    public String getShareCode() {
        return shareCode;
    }

    public void setShareCode(String shareCode) {
        this.shareCode = shareCode;
        super.addValidField("shareCode");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 50)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 50)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}