package cn.com.yict.framemax.frame.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Date;

/**
 * (FmxFile)实体类
 *
 * @author makejava
 * @since 2021-09-06 12:04:34
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FmxFileDto implements Serializable {
    private static final long serialVersionUID = 390662406452085579L;
    /**
     * 主键,文件标识
     */
    private Long fileId;
    /**
     * 业务类型,报表为0,邮件附件1,其他由业务系统自行扩展
     */
    private Integer bizType;
    /**
     * 业务主键标识,对应业务类型的表主键如:report_id,email_id
     */
    private String bizId;
    /**
     * 文件名
     */
    private String fileName;
    /**
     * 文件类型
     */
    private String fileMimeType;
    /**
     * 文件内容
     */
    private Object fileContent;
    /**
     * 文件备注
     */
    private String fileDesc;
    /**
     * 扩展属性1
     */
    private String fileAttr1;
    /**
     * 扩展属性2
     */
    private String fileAttr2;
    /**
     * 扩展属性3
     */
    private String fileAttr3;
    /**
     * 扩展属性4
     */
    private String fileAttr4;
    /**
     * 创建人
     */
    private String creator;
    /**
     * 创建时间
     */
    private Date createdTime;
    /**
     * 修改人
     */
    private String modifier;
    /**
     * 修改时间
     */
    private Date modifiedTime;
    /**
     * 乐观锁,版本号
     */
    private Integer sysVersion;


    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileMimeType() {
        return fileMimeType;
    }

    public void setFileMimeType(String fileMimeType) {
        this.fileMimeType = fileMimeType;
    }

    public Object getFileContent() {
        return fileContent;
    }

    public void setFileContent(Object fileContent) {
        this.fileContent = fileContent;
    }

    public String getFileDesc() {
        return fileDesc;
    }

    public void setFileDesc(String fileDesc) {
        this.fileDesc = fileDesc;
    }

    public String getFileAttr1() {
        return fileAttr1;
    }

    public void setFileAttr1(String fileAttr1) {
        this.fileAttr1 = fileAttr1;
    }

    public String getFileAttr2() {
        return fileAttr2;
    }

    public void setFileAttr2(String fileAttr2) {
        this.fileAttr2 = fileAttr2;
    }

    public String getFileAttr3() {
        return fileAttr3;
    }

    public void setFileAttr3(String fileAttr3) {
        this.fileAttr3 = fileAttr3;
    }

    public String getFileAttr4() {
        return fileAttr4;
    }

    public void setFileAttr4(String fileAttr4) {
        this.fileAttr4 = fileAttr4;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Date getModifiedTime() {
        return modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public Integer getSysVersion() {
        return sysVersion;
    }

    public void setSysVersion(Integer sysVersion) {
        this.sysVersion = sysVersion;
    }

}
