package cn.com.yict.framemax.frame.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for FMX_USER
 * 用户表
 */
@Entity
@Table(name = "FMX_USER")
@DynamicInsert
@DynamicUpdate
public class FmxUserModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
    
  
    /** USER_ID
    *用户标识
    */ 
    private Long userId;
    
    @Column(name = "USER_ID")
	@Id @GeneratedValue(strategy = GenerationType.AUTO)   
    public Long getUserId(){
        return this.userId;
    }
    
    public void setUserId(Long userId){
        this.userId = userId;
        super.addValidField("userId");
    }
    
  
    /** USER_NAME
    *用户名称
    */ 
    private String userName;
    
    @Column(name = "USER_NAME")
    public String getUserName(){
        return this.userName;
    }
    
    public void setUserName(String userName){
        this.userName = userName;
        super.addValidField("userName");
    }
    
  
    /** ACCOUNT
    *登录账号
    */ 
    private String account;
    
    @Column(name = "ACCOUNT")
    public String getAccount(){
        return this.account;
    }
    
    public void setAccount(String account){
        this.account = account;
        super.addValidField("account");
    }
    
  
    /** CENTRAL_ACCOUNT
    *中心账号
    */ 
    private String centralAccount;
    
    @Column(name = "CENTRAL_ACCOUNT")
    public String getCentralAccount(){
        return this.centralAccount;
    }
    
    public void setCentralAccount(String centralAccount){
        this.centralAccount = centralAccount;
        super.addValidField("centralAccount");
    }
    
  
    /** IS_LOCKED
    *是否锁定。Y是，N否
    */ 
    private String isLocked;
    
    @Column(name = "IS_LOCKED")
    public String getIsLocked(){
        return this.isLocked;
    }
    
    public void setIsLocked(String isLocked){
        this.isLocked = isLocked;
        super.addValidField("isLocked");
    }
    
  
    /** PASSWORD
    *登录密码
    */ 
    private String password;
    
    @Column(name = "PASSWORD")
    public String getPassword(){
        return this.password;
    }
    
    public void setPassword(String password){
        this.password = password;
        super.addValidField("password");
    }
    
  
    /** USER_EMP_NO
    *员工编号
    */ 
    private String userEmpNo;
    
    @Column(name = "USER_EMP_NO")
    public String getUserEmpNo(){
        return this.userEmpNo;
    }
    
    public void setUserEmpNo(String userEmpNo){
        this.userEmpNo = userEmpNo;
        super.addValidField("userEmpNo");
    }
    
  
    /** USER_EMAIL
    *联系邮箱
    */ 
    private String userEmail;
    
    @Column(name = "USER_EMAIL")
    public String getUserEmail(){
        return this.userEmail;
    }
    
    public void setUserEmail(String userEmail){
        this.userEmail = userEmail;
        super.addValidField("userEmail");
    }
    
    /** USER_PHONE
    *用户电话
    */ 
    private String userPhone;
    
    @Column(name = "USER_PHONE")
    public String getUserPhone(){
        return this.userPhone;
    }
    
    public void setUserPhone(String userPhone){
        this.userPhone = userPhone;
        super.addValidField("userPhone");
    }
    
    /** USER_BU_ID
    *用户电话
    */ 
    private String userBuId;
    
    @Column(name = "USER_BU_ID")
    public String getUserBuId(){
        return this.userBuId;
    }
    
    public void setUserBuId(String userBuId){
        this.userBuId = userBuId;
        super.addValidField("userBuId");
    }

    /** USER_LOGIN_TICKET
     *用户电话
     */
    private String userLoginTicket;

    @Column(name = "USER_LOGIN_TICKET")
    public String getUserLoginTicket(){
        return this.userLoginTicket;
    }

    public void setUserLoginTicket(String userLoginTicket){
        this.userLoginTicket = userLoginTicket;
        super.addValidField("userLoginTicket");
    }


    /** INCORRENT_COUNT
    *错误次数
    */ 
    private Integer incorrentCount;
    
    @Column(name = "INCORRENT_COUNT")
    public Integer getIncorrentCount(){
        return this.incorrentCount;
    }
    
    public void setIncorrentCount(Integer incorrentCount){
        this.incorrentCount = incorrentCount;
        super.addValidField("incorrentCount");
    }
    
  
    /** PASSWORD_CHANGE_DATE
    *密码修改日期
    */ 
    private java.util.Date passwordChangeDate;
    
    @Column(name = "PASSWORD_CHANGE_DATE")
    public java.util.Date getPasswordChangeDate(){
        return this.passwordChangeDate;
    }
    
    public void setPasswordChangeDate(java.util.Date passwordChangeDate){
        this.passwordChangeDate = passwordChangeDate;
        super.addValidField("passwordChangeDate");
    }
    
    /**
     * 版本号
     */
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION")
    @Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR")
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建日期
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME")
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER")
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改日期
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME")
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
}