package cn.com.yict.framemax.frame.rest;

import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.frame.entity.LargeModelConfigEntity;
import cn.com.yict.framemax.frame.entity.TimBreEntity;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jennie.chen
 * @date 2024/7/31
 **/
@Permission(Access.Anonymous)
public interface LargeModelConfigRest extends BaseRest {

    /**
     * 获取大模型列表
     *
     * @throws Exception
     */
    List<String> getLargeModel() throws Exception;

    /**
     * 保存当前选择的模型
     *
     * @throws Exception
     */
    LargeModelConfigEntity saveLargeModelConfig(@RequestBody LargeModelConfigEntity largeModelConfigEntity) throws Exception;


    /**
     * 查询音色列表
     *
     * @throws Exception
     */
    List<TimBreEntity> getTimBre() throws Exception;
}
