package cn.com.yict.framemax.frame.rest;

import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.frame.dto.FmxFileDto;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Permission(Access.Safety)
public interface MobileUpdateRest extends BaseRest {

    /**
     * 保存移动端更新文件
     *
     * @throws Exception
     */
    FmxFileDto saveMobilePackage(@RequestBody FmxFileDto fmxFileDto) throws Exception;

    /**
     * 校验移动端是否需要更新
     *
     * @param appName  移动端应用名称
     * @param versison 版本号
     * @return
     * @throws Exception
     */
    @Permission(Access.Anonymous)
    FmxFileDto checkMobilePackage(String appName, String versison, String platform) throws Exception;


    /**
     * 移动端版本记录
     *
     * @param fmxFileDto
     * @return
     * @throws Exception
     */
    @Permission(Access.Anonymous)
    List<FmxFileDto> mobilePackageList(@RequestBody FmxFileDto fmxFileDto, PagingInfo pagingInfo) throws Exception;
}
