package cn.com.yict.framemax.frame.rest.impl;


import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.frame.dto.FmxFileDto;
import cn.com.yict.framemax.frame.model.FmxFileModel;
import cn.com.yict.framemax.frame.rest.MobileUpdateRest;
import cn.com.yict.framemax.frame.service.MobileUpdateService;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class MobileUpdateRestImpl implements MobileUpdateRest {

    @Autowired
    private MobileUpdateService mobileUpdateService;

    @Override
    public FmxFileDto saveMobilePackage(FmxFileDto fmxFileDto) throws Exception {
        return this.convert(mobileUpdateService.saveMobilePackage(this.convert(fmxFileDto)));
    }

    @Override
    public FmxFileDto checkMobilePackage(String appName, String versison, String platform) throws Exception {
        return this.convert(this.mobileUpdateService.checkMobilePackage(appName, versison, platform));
    }

    /**
     * 移动端版本记录
     *
     * @param fmxFileDto
     * @return
     * @throws Exception
     */
    @Override
    public List<FmxFileDto> mobilePackageList(FmxFileDto fmxFileDto, PagingInfo pagingInfo) throws Exception {

        List<FmxFileModel> modelList = mobileUpdateService.mobilePackageList(this.convert(fmxFileDto), pagingInfo);
        if (CollectionUtils.isEmpty(modelList)) {
            return null;
        }
        List<FmxFileDto> list = new ArrayList<>();
        for (FmxFileModel model : modelList) {
            list.add(this.convert(model));
        }
        return list;
    }


    private FmxFileModel convert(FmxFileDto dto) {
        if (dto == null) {
            return null;
        }
        FmxFileModel fmxFileModel = new FmxFileModel();
        fmxFileModel.setFileId(dto.getFileId());
        fmxFileModel.setBizType(dto.getBizType());
        fmxFileModel.setBizId(dto.getBizId());
        fmxFileModel.setFileName(dto.getFileName());
        fmxFileModel.setFileMimeType(dto.getFileMimeType());
        fmxFileModel.setFileDesc(dto.getFileDesc());
        fmxFileModel.setFileAttr1(dto.getFileAttr1());
        fmxFileModel.setFileAttr2(dto.getFileAttr2());
        fmxFileModel.setFileAttr3(dto.getFileAttr3());
        fmxFileModel.setFileAttr4(dto.getFileAttr4());
        return fmxFileModel;

    }

    private FmxFileDto convert(FmxFileModel model) {
        if (model == null) {
            return null;
        }
        FmxFileDto fmxFileDto = new FmxFileDto();
        fmxFileDto.setFileId(model.getFileId());
        fmxFileDto.setBizType(model.getBizType());
        fmxFileDto.setBizId(model.getBizId());
        fmxFileDto.setFileName(model.getFileName());
        fmxFileDto.setFileMimeType(model.getFileMimeType());
        fmxFileDto.setFileContent(model.getFileContent());
        fmxFileDto.setFileDesc(model.getFileDesc());
        fmxFileDto.setFileAttr1(model.getFileAttr1());
        fmxFileDto.setFileAttr2(model.getFileAttr2());
        fmxFileDto.setFileAttr3(model.getFileAttr3());
        fmxFileDto.setFileAttr4(model.getFileAttr4());
        fmxFileDto.setCreator(model.getCreator());
        fmxFileDto.setCreatedTime(model.getCreatedTime());
        fmxFileDto.setModifier(model.getModifier());
        fmxFileDto.setModifiedTime(model.getModifiedTime());
        fmxFileDto.setSysVersion(model.getSysVersion());
        return fmxFileDto;

    }
}
