package cn.com.poc.agent_application.service.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationService;
import cn.com.poc.agent_application.constant.AgentApplicationGCConfigConstants;
import cn.com.poc.agent_application.request.*;
import cn.com.poc.agent_application.service.AiGcEditorService;
import cn.com.poc.common.utils.Assert;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 *
 */
@Service
public class AiGcEditorServiceImpl implements AiGcEditorService {

    @Resource
    private AgentApplicationService agentApplicationService;

    @Override
    public void articlePolish(ArticlePolishRequest request, HttpServletResponse httpServletResponse) throws Exception {

        Assert.notNull(request, "param is not null");
        String articleContent = request.getArticleContent();
        String editorRequired = request.getEditorRequired();
        Assert.notBlank(articleContent, "请选择需要润色的文字");
        agentApplicationService.editorFunction(AgentApplicationGCConfigConstants.EDITOR_ARTICLE_POLISH, articleContent, editorRequired, httpServletResponse);
    }

    @Override
    public void articleRefine(ArticleRefineRequest request, HttpServletResponse httpServletResponse) throws Exception {

        Assert.notNull(request, "param is not null");
        String articleContent = request.getArticleContent();
        String editorRequired = request.getEditorRequired();
        Assert.notBlank(articleContent, "请选择需要简写的文字");

        //调用提问
        agentApplicationService.editorFunction(AgentApplicationGCConfigConstants.EDITOR_ARTICLE_REFINE, articleContent, editorRequired, httpServletResponse);
    }

    @Override
    public void articleExpand(ArticleExpandRequest request, HttpServletResponse httpServletResponse) throws Exception {

        Assert.notNull(request, "param is not null");
        String articleContent = request.getArticleContent();
        String editorRequired = request.getEditorRequired();
        Assert.notBlank(articleContent, "请选择需要扩写的文字");

        //调用提问
        agentApplicationService.editorFunction(AgentApplicationGCConfigConstants.EDITOR_ARTICLE_EXPAND, articleContent, editorRequired, httpServletResponse);
    }



    @Override
    public void articleRewrite(ArticleRewriteRequest request, HttpServletResponse httpServletResponse) throws Exception {

        Assert.notNull(request, "param is not null");
        String articleContent = request.getArticleContent();
        String editorRequired = request.getEditorRequired();
        Assert.notBlank(articleContent, "请选择需要改写的文字");

        //调用提问
        agentApplicationService.editorFunction(AgentApplicationGCConfigConstants.EDITOR_ARTICLERE_WRITE, articleContent, editorRequired, httpServletResponse);
    }

    @Override
    public void articleModifyTone(ArticleModifyToneRequest request, HttpServletResponse httpServletResponse) throws Exception {

        Assert.notNull(request, "param is not null");
        String articleContent = request.getArticleContent();
        String editorRequired = request.getEditorRequired();
        Assert.notBlank(articleContent, "请选择需要修改的文字");

        //调用提问
        agentApplicationService.editorFunction(AgentApplicationGCConfigConstants.EDITOR_ARTICLE_MODIFY_TONE, articleContent, editorRequired, httpServletResponse);
    }

}
