package cn.com.poc.common.utils;

import cn.com.yict.framemax.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/4/27
 */
public class DatabaseUtil {

    private static Logger logger = LoggerFactory.getLogger(DatabaseUtil.class);

    private static final String DRIVER_NAME = "com.mysql.jdbc.Driver";

    private static final int CONNECT_TIMEOUT = 5000; // 连接超时时间（毫秒）

    private static final int SOCKET_TIMEOUT = 30000; // socket超时时间（毫秒）

    private static final String SQL_TABLE_INFO = "SELECT " +
            "    TABLE_NAME ," +
            "    TABLE_COMMENT," +
            "    TABLE_ROWS," +
            "    (SELECT COUNT(*) " +
            "     FROM INFORMATION_SCHEMA.COLUMNS " +
            "     WHERE TABLE_SCHEMA = t.TABLE_SCHEMA " +
            "       AND TABLE_NAME = t.TABLE_NAME) AS TABLE_COLUMN " +
            "FROM INFORMATION_SCHEMA.TABLES t " +
            "WHERE TABLE_SCHEMA = ?";


    /**
     * 测试数据库连接
     *
     * @param host
     * @param port
     * @param username
     * @param password
     * @param database
     * @return
     */
    public static boolean testConnect(String host, int port, String username, String password, String database) {
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database
                + "?connectTimeout=" + CONNECT_TIMEOUT // 连接超时（毫秒）
                + "&socketTimeout=" + SOCKET_TIMEOUT; // socket超时（毫秒）
        try {
            Class.forName(DRIVER_NAME);
            Connection connection = DriverManager.getConnection(url, username, password);
            connection.close();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 获取数据库表列表
     */
    public static List<TableInfo> getTableInfo(String host, int port, String username, String password, String database) {
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database
                + "?connectTimeout=" + CONNECT_TIMEOUT // 连接超时（毫秒）
                + "&socketTimeout=" + SOCKET_TIMEOUT; // socket超时（毫秒）
        try {
            Class.forName(DRIVER_NAME);
            Connection connection = DriverManager.getConnection(url, username, password);
            PreparedStatement preparedStatement = connection.prepareStatement(SQL_TABLE_INFO);
            preparedStatement.setString(1, database);
            ResultSet resultSet = preparedStatement.executeQuery();
            List<TableInfo> tableInfoList = new ArrayList<>();
            while (resultSet.next()) {
                TableInfo tableInfo = new TableInfo();
                tableInfo.setTABLE_NAME(resultSet.getString("TABLE_NAME"));
                tableInfo.setTABLE_COMMENT(resultSet.getString("TABLE_COMMENT"));
                tableInfo.setTABLE_ROWS(resultSet.getInt("TABLE_ROWS"));
                tableInfo.setTABLE_COLUMN(resultSet.getInt("TABLE_COLUMN"));
                tableInfoList.add(tableInfo);
            }
            connection.close();
            return tableInfoList;
        } catch (Exception e) {
            logger.error("连接数据库失败", e);
            return null;
        }
    }

    public static class TableInfo {
        private String TABLE_NAME;
        private String TABLE_COMMENT;
        private int TABLE_ROWS;
        private int TABLE_COLUMN;

        public String getTABLE_NAME() {
            return TABLE_NAME;
        }

        public void setTABLE_NAME(String TABLE_NAME) {
            this.TABLE_NAME = TABLE_NAME;
        }

        public String getTABLE_COMMENT() {
            return TABLE_COMMENT;
        }

        public void setTABLE_COMMENT(String TABLE_COMMENT) {
            this.TABLE_COMMENT = TABLE_COMMENT;
        }

        public int getTABLE_ROWS() {
            return TABLE_ROWS;
        }

        public void setTABLE_ROWS(int TABLE_ROWS) {
            this.TABLE_ROWS = TABLE_ROWS;
        }

        public int getTABLE_COLUMN() {
            return TABLE_COLUMN;
        }

        public void setTABLE_COLUMN(int TABLE_COLUMN) {
            this.TABLE_COLUMN = TABLE_COLUMN;
        }

        @Override
        public String toString() {
            return "TableInfo{" +
                    "TABLE_NAME='" + TABLE_NAME + '\'' +
                    ", TABLE_COMMENT='" + TABLE_COMMENT + '\'' +
                    ", TABLE_ROWS=" + TABLE_ROWS +
                    ", TABLE_COLUMN=" + TABLE_COLUMN +
                    '}';
        }
    }

}
