package cn.com.poc.equity.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.equity.service.BizPaymentPackageConfigurationService;
import cn.com.poc.equity.model.BizPaymentPackageConfigurationModel;
import cn.com.poc.equity.entity.BizPaymentPackageConfigurationEntity;
import cn.com.poc.equity.convert.BizPaymentPackageConfigurationConvert;
import cn.com.poc.equity.repository.BizPaymentPackageConfigurationRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizPaymentPackageConfigurationServiceImpl extends BaseServiceImpl
 			 implements BizPaymentPackageConfigurationService {
   
   @Resource
   private BizPaymentPackageConfigurationRepository repository;
    			 
   public BizPaymentPackageConfigurationEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizPaymentPackageConfigurationModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizPaymentPackageConfigurationConvert.modelToEntity(model);
   }

       
   public List<BizPaymentPackageConfigurationEntity> findByExample(BizPaymentPackageConfigurationEntity example,PagingInfo pagingInfo){
        List<BizPaymentPackageConfigurationEntity> result = new  ArrayList<BizPaymentPackageConfigurationEntity>();
        BizPaymentPackageConfigurationModel model = new BizPaymentPackageConfigurationModel();
        if (example != null){
            model = BizPaymentPackageConfigurationConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizPaymentPackageConfigurationModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizPaymentPackageConfigurationConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizPaymentPackageConfigurationEntity save(BizPaymentPackageConfigurationEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizPaymentPackageConfigurationModel model = BizPaymentPackageConfigurationConvert.entityToModel(entity);
        BizPaymentPackageConfigurationModel saveModel =  this.repository.save(model);
        return BizPaymentPackageConfigurationConvert.modelToEntity(saveModel);
    }

    public BizPaymentPackageConfigurationEntity update(BizPaymentPackageConfigurationEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizPaymentPackageConfigurationModel model = this.repository.get(entity.getId());

       if (entity.getType() != null){
        model.setType(entity.getType());
       }
       if (entity.getDomain() != null){
        model.setDomain(entity.getDomain());
       }
       if (entity.getName() != null){
        model.setName(entity.getName());
       }
       if (entity.getExpiredNum() != null){
        model.setExpiredNum(entity.getExpiredNum());
       }
       if (entity.getExpiredType() != null){
        model.setExpiredType(entity.getExpiredType());
       }
       if (entity.getAmount() != null){
        model.setAmount(entity.getAmount());
       }
       if (entity.getResourceCount() != null){
        model.setResourceCount(entity.getResourceCount());
       }
       if (entity.getOriginalPrice() != null){
        model.setOriginalPrice(entity.getOriginalPrice());
       }
       if (entity.getIsShowOriginalPrice() != null){
        model.setIsShowOriginalPrice(entity.getIsShowOriginalPrice());
       }
       if (entity.getSort() != null){
        model.setSort(entity.getSort());
       }
       if (entity.getDescription() != null){
        model.setDescription(entity.getDescription());
       }
       if (entity.getExtraData() != null){
        model.setExtraData(entity.getExtraData());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizPaymentPackageConfigurationModel saveModel =  this.repository.save(model);
        return BizPaymentPackageConfigurationConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizPaymentPackageConfigurationModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}