package cn.com.poc.expose.aggregate;

import cn.com.poc.agent_application.entity.BizAgentApplicationApiProfileEntity;
import cn.com.poc.agent_application.query.MemberCollectQueryItem;
import cn.com.yict.framemax.data.model.PagingInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface AgentApplicationExposeService {

    /**
     * 调用 已发布Agent应用
     *
     * @param agentId   应用ID
     * @param dialogsId 对话ID
     * @param input     用户输入
     * @param fileUrls  文件URL
     * @param channel   渠道
     * @param imageUrl  图片URL
     */
    void callAgentApplication(String agentId, String dialogsId, String input, List<String> fileUrls, String channel, String imageUrl, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 追问AI生成
     *
     * @param input 问题输入
     * @return
     */
    List<String> createContinueQuestions(String input);

    /**
     * [首页] 获取推荐问
     *
     * @param xlang    语言 zh-cn 中文简体 en 英文 zh-tw 中文繁体
     * @param memberId 用户ID
     */
    List<String> getRecommendQuestions(String xlang, Long memberId) throws InterruptedException;

    /**
     * [首页] 生成推荐问
     *
     * @throws InterruptedException
     */
    void createRecommendQuestion();

    /**
     * 【首页】 获取用户已收藏的应用列表
     */
    List<MemberCollectQueryItem> getCollectedApplications(Long memberId, PagingInfo pagingInfo);

    /**
     * 获取用户在当前应用的自动播放配置
     *
     * @param memberId 用户ID
     * @param agentId  应用ID
     */
    String autoPlayByAgentId(Long memberId, String agentId);

    /**
     * 设置用户在当前应用的自动播放配置
     *
     * @param memberId 用户ID
     * @param agentId  应用ID
     * @param autoPlay 自动播放配置 Y/N
     */
    String enableAutoPlay(Long memberId, String agentId, String autoPlay);


    /**
     * 获取应用的API配置
     *
     * @param memberId 用户ID
     * @return 应用API配置
     */
    BizAgentApplicationApiProfileEntity getApiProfile(Long memberId);

    /**
     * 重置应用的API配置
     *
     * @param memberId 用户ID
     * @return 应用API配置
     */
    BizAgentApplicationApiProfileEntity resetApiProfile(Long memberId) throws Exception;

}
