package cn.com.poc.thirdparty.resource.demand.ai.aggregate;

import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.ChunkInfo;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeChunkResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeConfig;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeStructResult;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

/**
 * 问答知识服务接口
 *
 * @author alex.yao
 * @date 2025/2/26
 */
public interface DemandQAKnowledgeService {

    /**
     * 获取知识库分片信息
     *
     * @param knowledgeId 知识库ID
     * @param query       模糊查询
     * @param pagingInfo  分页信息
     * @return 知识库分片信息
     */
    QAKnowledgeChunkResult getKnowledgeChunkInfos(String knowledgeId, String query, PagingInfo pagingInfo);


    /**
     * 开关知识库分片信息
     *
     * @param knowledgeId     知识库ID
     * @param chunkRelationId 分片关系ID
     * @param isOpen          是否开启 Y-开启 N-关闭
     */
    void openKnowledgeChunk(String knowledgeId, String chunkRelationId, String isOpen);

    /**
     * 删除知识库分片
     *
     * @param knowledgeId     知识库ID
     * @param chunkRelationId 分片关系ID
     */
    void deleteKnowledgeChunk(String knowledgeId, String chunkRelationId);

    /**
     * 批量删除知识库分片
     *
     * @param knowledgeId
     * @param chunkRelationIds
     */
    void batchDeleteKnowledgeChunk(String knowledgeId, List<String> chunkRelationIds);

    /**
     * 修改分片内容
     *
     * @param knowledgeId     知识库ID
     * @param chunkRelationId 分片关系ID
     * @param structId        结构ID
     * @param content         内容
     */
    void updateKnowledgeChunkDoc(String knowledgeId, String chunkRelationId, Long structId, String content);


    /**
     * 批量更新分片内容
     *
     * @param knowledgeId
     * @param chunkRelationId
     * @param chunkInfos
     */
    void updateKnowledgeChunkDoc(String knowledgeId, String chunkRelationId, List<ChunkInfo> chunkInfos);

    /**
     * 新增分片
     *
     * @param knowledgeId 知识库ID
     * @param chunkInfos  分片信息
     * @param sort        排序 0以上， 越小越大
     */
    void addKnowledgeChunk(String knowledgeId, List<ChunkInfo> chunkInfos, Integer sort);

    /**
     * 更新分片排序
     *
     * @param knowledgeId     知识库ID
     * @param chunkRelationId 分片关系ID
     * @param sort            排序 0以上， 越小越大
     */
    void updateKnowledgeChunkSort(String knowledgeId, String chunkRelationId, Integer sort);

    /**
     * 更新结构
     *
     * @param knowledgeId 知识库ID
     * @param structId    结构ID
     * @param structName  结构名称
     * @param isIndex     是否索引 Y-是 N-否
     */
    void updateKnowledgeStruct(String knowledgeId, Long structId, String structName, String isIndex);

    /**
     * 获取结构
     *
     * @param knowledgeId 知识库ID
     */
    QAKnowledgeStructResult getKnowledgeStruct(String knowledgeId);

}
