package cn.com.poc.thirdparty.resource.demand.ai.entity.generations;

import cn.com.poc.thirdparty.resource.demand.ai.entity.BaiduErrorResult;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

/**
 * @Author: Zackery
 * @Description:
 * @Date: 2024/4/11 10:55
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaiduAISailsImage2TextResult extends BaiduErrorResult implements Serializable {

    /**
     * 本轮对话的ID
     */
    private String id;

    /**
     * 回包类型。 completion：文本生成返回
     */
    private String object;

    /**
     * 时间戳
     */
    private Long created;

    /**
     * 表示当前子句的序号。只有在流式接口模式下会返回该字段
     */
    private Long sentenceId;

    /**
     * 表示当前子句是否是最后一句。只有在流式接口模式下会返回该字段
     */
    private Boolean isEnd;

    /**
     * 对话返回结果
     */
    private String result;

    private Integer isSafe;

    /**
     * token统计信息
     */
    private BaiduAISailsImage2TextUsage usage;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getCreated() {
        return created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getSentenceId() {
        return sentenceId;
    }

    public void setSentenceId(Long sentenceId) {
        this.sentenceId = sentenceId;
    }

    public Boolean getEnd() {
        return isEnd;
    }

    public void setEnd(Boolean end) {
        isEnd = end;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Integer getIsSafe() {
        return isSafe;
    }

    public void setIsSafe(Integer isSafe) {
        this.isSafe = isSafe;
    }

    public BaiduAISailsImage2TextUsage getUsage() {
        return usage;
    }

    public void setUsage(BaiduAISailsImage2TextUsage usage) {
        this.usage = usage;
    }

}
