package cn.com.poc.thirdparty.resource.demand.ai.function.top_search;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.tianju.api.TianApi;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianCommonResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianDouyinTopSearch;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianResult;
import cn.hutool.core.collection.ListUtil;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/1/17
 */
@Component
public class DouyinTopSearchFunction extends AbstractLargeModelFunction {
    private final String DESC = "该方法获取今天抖音的热点信息";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("douyin_search_top")
            .description(DESC)
            .build();

    @Resource
    private TianApi tianApi;

    @Override
    public AbstractFunctionResult<List<TianDouyinTopSearch>> doFunction(String content, String identifier) {
        AbstractFunctionResult<List<TianDouyinTopSearch>> result = new AbstractFunctionResult<>();

        TianCommonResult<TianDouyinTopSearch> douyinTopSearch = tianApi.getDouyinTopSearch();
        TianResult<TianDouyinTopSearch> searchTianResult = douyinTopSearch.getResult();
        List<TianDouyinTopSearch> list = searchTianResult.getList();
        result.setFunctionResult(list);
        result.setPromptContent(JsonUtils.serialize(list));
        return result;
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return getLLMConfig();
    }
}
