package cn.com.poc.thirdparty.resource.demand.ai.function.top_search;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.tianju.api.TianApi;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianCommonResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianWeiboTopSearch;
import cn.hutool.core.collection.ListUtil;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/1/16
 */
@Component
public class WeiboTopSearchFunction extends AbstractLargeModelFunction {

    private final String DESC = "该方法获取今天微博的热点信息";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("weibo_search_top")
            .description(DESC)
            .build();

    @Resource
    private TianApi tianApi;

    @Override
    public AbstractFunctionResult<List<TianWeiboTopSearch>> doFunction(String content, String identifier) {
        AbstractFunctionResult<List<TianWeiboTopSearch>> result = new AbstractFunctionResult<List<TianWeiboTopSearch>>();

        TianCommonResult<TianWeiboTopSearch> weiboTopSearch = tianApi.getWeiboTopSearch();
        TianResult<TianWeiboTopSearch> tianWeiboTopSearchTianResult = weiboTopSearch.getResult();
        List<TianWeiboTopSearch> list = tianWeiboTopSearchTianResult.getList();

        result.setFunctionResult(list);
        result.setPromptContent(JsonUtils.serialize(list));

        return result;
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return getLLMConfig();
    }
}
