package cn.com.poc.agent_application.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationApiFilesService;
import cn.com.poc.agent_application.model.BizAgentApplicationApiFilesModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationApiFilesEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationApiFilesConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationApiFilesRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAgentApplicationApiFilesServiceImpl extends BaseServiceImpl
 			 implements BizAgentApplicationApiFilesService {
   
   @Resource
   private BizAgentApplicationApiFilesRepository repository;
    			 
   public BizAgentApplicationApiFilesEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAgentApplicationApiFilesModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizAgentApplicationApiFilesConvert.modelToEntity(model);
   }

       
   public List<BizAgentApplicationApiFilesEntity> findByExample(BizAgentApplicationApiFilesEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAgentApplicationApiFilesEntity> result = new  ArrayList<BizAgentApplicationApiFilesEntity>();
        BizAgentApplicationApiFilesModel model = new BizAgentApplicationApiFilesModel();
        if (example != null){
            model = BizAgentApplicationApiFilesConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAgentApplicationApiFilesModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationApiFilesConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationApiFilesEntity save(BizAgentApplicationApiFilesEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAgentApplicationApiFilesModel model = BizAgentApplicationApiFilesConvert.entityToModel(entity);
        BizAgentApplicationApiFilesModel saveModel =  this.repository.save(model);
        return BizAgentApplicationApiFilesConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationApiFilesEntity update(BizAgentApplicationApiFilesEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAgentApplicationApiFilesModel model = this.repository.get(entity.getId());

       if (entity.getAgentId() != null){
        model.setAgentId(entity.getAgentId());
       }
       if (entity.getConversationId() != null){
        model.setConversationId(entity.getConversationId());
       }
       if (entity.getFileId() != null){
        model.setFileId(entity.getFileId());
       }
       if (entity.getFileUrl() != null){
        model.setFileUrl(entity.getFileUrl());
       }
       if (entity.getExpiredTime() != null){
        model.setExpiredTime(entity.getExpiredTime());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizAgentApplicationApiFilesModel saveModel =  this.repository.save(model);
        return BizAgentApplicationApiFilesConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAgentApplicationApiFilesModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}