package cn.com.poc.common.utils;

import cn.com.poc.common.constant.BizSnKeyEnum;
import cn.com.poc.common.constant.BizSnRedisKeyEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;


public class GeneratingSnUtils {

    private static Logger logger = LoggerFactory.getLogger(GeneratingSnUtils.class);

    public static List<String> batchGenerationSn(BizSnKeyEnum bizType, Integer qty) {
        Assert.notNull(bizType);

        qty = qty != null ? qty : 1;

        List<String> sns = new ArrayList<>();

        for (int i = 0; i < qty; i++) {
            // 业务前缀（2位） + 时间戳（13位） + 随机数（3位）
            sns.add(bizType.getSnPrefix() + System.currentTimeMillis() + RandomCodeUtils.generateNumber(3));
        }

        logger.info("批量生成编号Prefix:[{}]-[{}]", bizType.getSnPrefix(), JsonUtils.serialize(sns));

        return sns;
    }

    public static String generationSn(BizSnKeyEnum bizType) {
        return batchGenerationSn(bizType, 1).get(0);
    }

}
