package cn.com.poc.data_analyze.constants;

/**
 * 数据来源渠道枚举
 *
 * @author alex.yao
 * @date 2024/12/10
 */
public enum DataAnalyzeChannelEnum {

    /**
     * 预览调试
     */
    preview("preview"),

    /**
     * 多模型调试
     */
    multi_preview("multi_preview"),

    /**
     * 首页
     */
    index("index"),

    /**
     * 应用广场
     */
    mall("mall"),

    /**
     * 链接分享
     */
    link_share("link_share"),

    /**
     * API调用
     */
    api("api"),
    ;
    private String channel;

    public String getChannel() {
        return channel;
    }

    DataAnalyzeChannelEnum(String channel) {
        this.channel = channel;
    }

}
