package cn.com.poc.knowledge.aggregate;

import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.ChunkInfo;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeChunkResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeConfig;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/2/26
 */
public interface QAKnowledgeService {

    /**
     * 获取知识库分片
     *
     * @param kdId       文档ID
     * @param query      模糊查询
     * @param pagingInfo 分页信息
     */
    QAKnowledgeChunkResult getChunkInfo(Integer kdId, String query, PagingInfo pagingInfo);

    /**
     * 开关知识库分片
     *
     * @param kdId            文档ID
     * @param chunkRelationId 分片关系id
     * @param isOpen          是否开启 Y/N
     */
    void openKnowledgeChunk(Integer kdId, String chunkRelationId, String isOpen);

    /**
     * 删除知识库分片
     *
     * @param kdId            文档ID
     * @param chunkRelationId 分片关系id
     */
    void deleteKnowledgeChunk(Integer kdId, String chunkRelationId);

    /**
     * 更新知识库分片内容
     *
     * @param kdId            文档ID
     * @param chunkRelationId 分片关系id
     * @param structId        结构id
     * @param content         分片内容
     */
    void updateKnowledgeChunkDoc(Integer kdId, String chunkRelationId, Long structId, String content);

    /**
     * 新增知识库分片
     *
     * @param kdId       文档ID
     * @param chunkInfos 分片内容
     * @param chunkSort  分片排序
     */
    void addKnowledgeChunk(Integer kdId, List<ChunkInfo> chunkInfos, Integer chunkSort);

    /**
     * 更新知识库结构
     *
     * @param kdId       文档ID
     * @param structId   结构id
     * @param structName 结构名称
     * @param isIndex    是否索引 Y/N
     */
    void updateKnowledgeStruct(Integer kdId, Long structId, String structName, String isIndex);

    /**
     * 获取知识库结构
     *
     * @param kdId 文档ID
     * @return
     */
    List<QAKnowledgeConfig> getKnowledgeStruct(Integer kdId);

    /**
     * 更新分片排序
     */
    void updateKnowledgeChunkSort(Integer kdId, String chunkRelationId, Integer chunkSort);
}
