package cn.com.poc.knowledge.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_knowledge_info
 * 知识库信息配置
 */
@Entity
@Table(name = "biz_knowledge_info")
@DynamicInsert
@DynamicUpdate
public class BizKnowledgeInfoModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     */
    private java.lang.Integer id;

    @Column(name = "id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Integer getId() {
        return this.id;
    }

    public void setId(java.lang.Integer id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * knowledge_name
     * 知识库名字
     */
    private java.lang.String knowledgeName;

    @Column(name = "knowledge_name", length = 100)
    public java.lang.String getKnowledgeName() {
        return this.knowledgeName;
    }

    public void setKnowledgeName(java.lang.String knowledgeName) {
        this.knowledgeName = knowledgeName;
        super.addValidField("knowledgeName");
    }

    /**
     * knowledge_type
     * 知识库类型 QA-问答 Base-基础
     */
    private String knowledgeType;

    @Column(name = "knowledge_type", length = 5)
    public String getKnowledgeType() {
        return this.knowledgeType;
    }

    public void setKnowledgeType(String knowledgeType) {
        this.knowledgeType = knowledgeType;
        super.addValidField("knowledgeType");
    }

    /**
     * member_id
     * 用户ID
     */
    private java.lang.String memberId;

    @Column(name = "member_id", length = 100)
    public java.lang.String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(java.lang.String memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * kd_ids
     * 关联的文件ID
     */
    private java.lang.String kdIds;

    @Column(name = "kd_ids", length = 1073741824)
    public java.lang.String getKdIds() {
        return this.kdIds;
    }

    public void setKdIds(java.lang.String kdIds) {
        this.kdIds = kdIds;
        super.addValidField("kdIds");
    }


    /**
     * train_status
     * 状态：未执行-Unopened、 排队-Line 、训练中-Training、 完成-Complete、失败-Fail
     */
    private java.lang.String trainStatus;

    @Column(name = "train_status", length = 15)
    public java.lang.String getTrainStatus() {
        return this.trainStatus;
    }

    public void setTrainStatus(java.lang.String trainStatus) {
        this.trainStatus = trainStatus;
        super.addValidField("trainStatus");
    }


    /**
     * knowledge_desc
     */
    private java.lang.String knowledgeDesc;

    @Column(name = "knowledge_desc", length = 500)
    public java.lang.String getKnowledgeDesc() {
        return this.knowledgeDesc;
    }

    public void setKnowledgeDesc(java.lang.String knowledgeDesc) {
        this.knowledgeDesc = knowledgeDesc;
        super.addValidField("knowledgeDesc");
    }

    /**
     * is_open
     * 是否开启 Y 是  N 否
     */
    private java.lang.String isOpen;

    @Column(name = "is_open", length = 1)
    public java.lang.String getIsOpen() {
        return this.isOpen;
    }

    public void setIsOpen(java.lang.String isOpen) {
        this.isOpen = isOpen;
        super.addValidField("isOpen");
    }


    /**
     * is_deleted
     * 是否删除 Y 是  N 否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 50)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 50)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}