package cn.com.poc.knowledge.rest.impl;

import cn.com.poc.knowledge.aggregate.QAKnowledgeService;
import cn.com.poc.knowledge.dto.UpsertChunkInfoDto;
import cn.com.poc.knowledge.rest.QAKnowledgeRest;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeChunkResult;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/2/26
 */
@Component
public class QAKnowledgeRestImpl implements QAKnowledgeRest {

    @Resource
    private QAKnowledgeService qaKnowledgeService;

    @Override
    public void openKnowledgeChunk(UpsertChunkInfoDto dto) {
        qaKnowledgeService.openKnowledgeChunk(dto.getKdId(), dto.getChunkRelationId(), dto.getIsOpen());
    }

    @Override
    public void deleteKnowledgeChunk(UpsertChunkInfoDto dto) {
        qaKnowledgeService.deleteKnowledgeChunk(dto.getKdId(), dto.getChunkRelationId());
    }

    @Override
    public void updateKnowledgeChunkDoc(UpsertChunkInfoDto dto) {
        qaKnowledgeService.updateKnowledgeChunkDoc(dto.getKdId(), dto.getChunkRelationId(), dto.getStructId(), dto.getChunkContent());
    }

    @Override
    public void addKnowledgeChunk(UpsertChunkInfoDto dto) {
        qaKnowledgeService.addKnowledgeChunk(dto.getKdId(), dto.getChunkInfos(), dto.getChunkSort());
    }

    @Override
    public QAKnowledgeChunkResult getQAKnowledgeChunks(Integer kdId, String query, PagingInfo pagingInfo) {
        return qaKnowledgeService.getChunkInfo(kdId, query, pagingInfo);
    }

    @Override
    public void updateKnowledgeChunk(Integer kdId, Long structId, String structName, String isIndex) {
        qaKnowledgeService.updateKnowledgeStruct(kdId, structId, structName, isIndex);
    }

    @Override
    public void batchDeleteKnowledgeChunks(Integer kdId, List<String> chunkRelationIds) {
        for (String chunkRelationId : chunkRelationIds) {
            qaKnowledgeService.deleteKnowledgeChunk(kdId, chunkRelationId);
        }
    }

    @Override
    public void updateChunkSort(Integer kdId, String chunkRelationId, Integer sort) {
        qaKnowledgeService.updateKnowledgeChunkSort(kdId, chunkRelationId, sort);
    }
}
