package cn.com.poc.knowledge.service.impl;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.knowledge.query.KnowledgeInfosQueryCondition;
import cn.com.poc.knowledge.query.KnowledgeInfosQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.knowledge.service.BizKnowledgeInfoService;
import cn.com.poc.knowledge.model.BizKnowledgeInfoModel;
import cn.com.poc.knowledge.entity.BizKnowledgeInfoEntity;
import cn.com.poc.knowledge.convert.BizKnowledgeInfoConvert;
import cn.com.poc.knowledge.repository.BizKnowledgeInfoRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import com.alibaba.fastjson.TypeReference;
import org.apache.commons.collections4.ListUtils;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizKnowledgeInfoServiceImpl extends BaseServiceImpl
        implements BizKnowledgeInfoService {

    @Resource
    private BizKnowledgeInfoRepository repository;

    public BizKnowledgeInfoEntity get(java.lang.Integer id) {
        Assert.notNull(id);
        BizKnowledgeInfoModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizKnowledgeInfoConvert.modelToEntity(model);
    }


    public List<BizKnowledgeInfoEntity> findByExample(BizKnowledgeInfoEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizKnowledgeInfoEntity> result = new ArrayList<BizKnowledgeInfoEntity>();
        BizKnowledgeInfoModel model = new BizKnowledgeInfoModel();
        if (example != null) {
            model = BizKnowledgeInfoConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizKnowledgeInfoModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizKnowledgeInfoConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizKnowledgeInfoEntity save(BizKnowledgeInfoEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizKnowledgeInfoModel model = BizKnowledgeInfoConvert.entityToModel(entity);
        BizKnowledgeInfoModel saveModel = this.repository.save(model);
        return BizKnowledgeInfoConvert.modelToEntity(saveModel);
    }

    public BizKnowledgeInfoEntity update(BizKnowledgeInfoEntity entity) {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizKnowledgeInfoModel model = this.repository.get(entity.getId());

        if (entity.getKnowledgeName() != null) {
            model.setKnowledgeName(entity.getKnowledgeName());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getKdIds() != null) {
            model.setKdIds(entity.getKdIds());
        }
        if (entity.getTrainStatus() != null) {
            model.setTrainStatus(entity.getTrainStatus());
        }
        if (entity.getKnowledgeDesc() != null) {
            model.setKnowledgeDesc(entity.getKnowledgeDesc());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getIsOpen() != null) {
            model.setIsOpen(entity.getIsOpen());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizKnowledgeInfoModel saveModel = this.repository.save(model);
        return BizKnowledgeInfoConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizKnowledgeInfoModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<KnowledgeInfosQueryItem> knowledgeInfos(KnowledgeInfosQueryCondition condition, PagingInfo pagingInfo) throws Exception {
        return this.sqlDao.query(condition, KnowledgeInfosQueryItem.class, "CREATED_TIME DESC", pagingInfo);
    }

    @Override
    public void removeDocument(Integer knowledgeInfoId, Integer kdId) {
        BizKnowledgeInfoModel bizKnowledgeInfoModel = this.repository.get(knowledgeInfoId);
        if (bizKnowledgeInfoModel != null) {
            String kdIds = bizKnowledgeInfoModel.getKdIds();
            if (!StringUtils.isEmpty(kdIds)) {
                List<String> kdIdList = JsonUtils.deSerialize(kdIds, new TypeReference<List<String>>() {
                }.getType());
                kdIdList.remove(kdId.toString());
                kdIds = JsonUtils.serialize(kdIdList.stream().map(Integer::valueOf).distinct().collect(Collectors.toList()));
                bizKnowledgeInfoModel.setKdIds(kdIds);
                this.repository.save(bizKnowledgeInfoModel);
            }
        }
    }
}