package cn.com.poc.thirdparty.resource.demand.ai.aggregate.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.DemandQAKnowledgeService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.UpsertChunkInfoRequest;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.*;
import cn.com.poc.thirdparty.resource.demand.ai.route.DgtoolsApiRoute;
import cn.com.poc.thirdparty.resource.demand.dgTools.DgtoolsAbstractHttpClient;
import cn.com.poc.thirdparty.resource.demand.member.service.DemandAuthService;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/2/26
 */
@Service
public class DemandQAKnowledgeServiceImpl implements DemandQAKnowledgeService {

    @Resource
    private DgtoolsAbstractHttpClient dgToolsAbstractHttpClient;

    @Resource
    private DemandAuthService demandAuthService;

    @Override
    public QAKnowledgeChunkResult getKnowledgeChunkInfos(String knowledgeId, String query, PagingInfo pagingInfo) {
        Assert.notBlank(knowledgeId);
        QAKnowledgeResponse response = new QAKnowledgeResponse();
        response.setKnowledgeId(knowledgeId);
        response.setQuery(query);
        return dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.GET_QA_KNOWLEDGE_CHUNK_INFOS, response, getHeaders(), pagingInfo);
    }

    @Override
    public void openKnowledgeChunk(String knowledgeId, String chunkRelationId, String isOpen) {
        Assert.notBlank(knowledgeId);
        Assert.notBlank(chunkRelationId);
        Assert.notBlank(isOpen);
        Assert.isTrue(isOpen.equals(CommonConstant.YOrN.N) || isOpen.equals(CommonConstant.YOrN.Y));
        UpsertChunkInfoRequest request = new UpsertChunkInfoRequest();
        request.setKnowledgeId(knowledgeId);
        request.setChunkRelationId(chunkRelationId);
        request.setIsOpen(isOpen);
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.OPEN_QA_KNOWLEDGE_CHUNK, request, getHeaders());
    }

    @Override
    public void deleteKnowledgeChunk(String knowledgeId, String chunkRelationId) {
        Assert.notBlank(knowledgeId);
        Assert.notBlank(chunkRelationId);
        UpsertChunkInfoRequest request = new UpsertChunkInfoRequest();
        request.setKnowledgeId(knowledgeId);
        request.setChunkRelationId(chunkRelationId);
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.DELETE_QA_KNOWLEDGE_CHUNK, request, getHeaders());
    }

    @Override
    public void updateKnowledgeChunkDoc(String knowledgeId, String chunkRelationId, Long structId, String content) {
        Assert.notBlank(knowledgeId);
        Assert.notBlank(chunkRelationId);
        UpsertChunkInfoRequest request = new UpsertChunkInfoRequest();
        request.setKnowledgeId(knowledgeId);
        request.setChunkRelationId(chunkRelationId);
        request.setStructId(structId);
        request.setChunkContent(content);
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.UPDATE_QA_KNOWLEDGE_CHUNK, request, getHeaders());
    }

    @Override
    public void addKnowledgeChunk(String knowledgeId, List<ChunkInfo> chunkInfos, Integer sort) {
        Assert.notBlank(knowledgeId);
        Assert.notEmpty(chunkInfos);
        Assert.notNull(sort);
        Assert.isTrue(sort >= 0);
        UpsertChunkInfoRequest request = new UpsertChunkInfoRequest();
        request.setKnowledgeId(knowledgeId);
        request.setChunkInfos(chunkInfos);
        request.setChunkSort(sort);
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.ADD_QA_KNOWLEDGE_CHUNK, request, getHeaders());

    }

    @Override
    public void updateKnowledgeChunkSort(String knowledgeId, String chunkRelationId, Integer sort) {
        Assert.notBlank(knowledgeId);
        Assert.notBlank(chunkRelationId);
        Assert.notNull(sort);
        Assert.isTrue(sort >= 0);
        UpsertChunkInfoRequest request = new UpsertChunkInfoRequest();
        request.setKnowledgeId(knowledgeId);
        request.setChunkRelationId(chunkRelationId);
        request.setChunkSort(sort);
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.SORT_QA_KNOWLEDGE_CHUNK, request, getHeaders());
    }

    @Override
    public void updateKnowledgeStruct(String knowledgeId, Long structId, String structName, String isIndex) {
        Assert.notBlank(knowledgeId);
        Assert.notNull(structId);
        UpdateQAKnowledgeStructRequest request = new UpdateQAKnowledgeStructRequest();
        request.setKnowledgeId(knowledgeId);
        request.setStructId(structId);
        request.setStructName(structName);
        request.setIsIndex(isIndex);
        dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.UPDATE_QA_KNOWLEDGE_STRUCT, request, getHeaders());
    }

    @Override
    public List<QAKnowledgeConfig> getKnowledgeStruct(String knowledgeId) {
        Assert.notBlank(knowledgeId);
        QAKnowledgeConfigRequest request = new QAKnowledgeConfigRequest();
        request.setKnowledgeId(knowledgeId);
        QAKnowledgeConfigResult qaKnowledgeConfigResult = dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.DgtoolsAI.GET_QA_KNOWLEDGE_STRUCT, request, getHeaders());
        return qaKnowledgeConfigResult.getQaKnowledgeConfigs();
    }

    private List<Header> getHeaders() {
        List<Header> headers = new ArrayList<>();
        headers.add(DgtoolsApiRoute.JSON_HEADER);
        headers.add(DgtoolsApiRoute.AI_HEADER);
        headers.add(new BasicHeader(DgtoolsApiRoute.HEADER_X_PLATFORM_AUTHORIZATION, demandAuthService.getToken()));
        return headers;
    }
}
