package cn.com.poc.user.builder;


import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.config.Config;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class LoginChannelTest {

    @Autowired
    @InjectMocks
    EmailLoginChannel emailLoginChannel;

    @Autowired
    @InjectMocks
    SmsLoginChannel smsLoginChannel;

    @Mock
    JudgeCodeService judgeCodeService;

    @Before
    public void setup() {
        // 启用 Mockito 注解
        MockitoAnnotations.initMocks(this);
    }

    @Test(expected = I18nMessageException.class)
    @Transactional
    @Rollback
    public void testEmailDoLogin_judgeCodeError() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(false);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        emailLoginChannel.doLogin(memberLoginRequest);
    }


    @Test
    @Transactional
    @Rollback
    public void testEmailDoLogin() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) emailLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
        assertEquals(memberInfoEntity.getMemberId(), Integer.valueOf(197));
    }

    @Test
    @Transactional
    @Rollback
    public void testEmailDoLogin_registerNewAccount() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao1@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) emailLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
    }

    @Test
    @Transactional
    @Rollback
    public void testSmsDoLogin() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("13602787613");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) smsLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
        assertEquals(memberInfoEntity.getMemberId(), Integer.valueOf(197));
    }

    @Test
    @Transactional
    @Rollback
    public void testSmsDoLogin_registerNewAccount() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("13602787614");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) smsLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
    }

    @Test
    public void testGoogleLogin_idTokenVerify() throws GeneralSecurityException, IOException {
        String idTokenString = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImFiODYxNGZmNjI4OTNiYWRjZTVhYTc5YTc3MDNiNTk2NjY1ZDI0NzgiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhenAiOiI4Njc5ODUwMTY3NTktbjlxajAwazE3NG45YmlicnRycW5ndnQ4OXZibW5qcnAuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJhdWQiOiI4Njc5ODUwMTY3NTktbjlxajAwazE3NG45YmlicnRycW5ndnQ4OXZibW5qcnAuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJzdWIiOiIxMDQwNzE2MTExMDgxOTEzMDA4NTAiLCJlbWFpbCI6Inlhb3NoYW5nanVuMjRAZ21haWwuY29tIiwiZW1haWxfdmVyaWZpZWQiOnRydWUsIm5iZiI6MTczNTUyNTYzMCwibmFtZSI6InNoYW5nanVuIHlhbyIsInBpY3R1cmUiOiJodHRwczovL2xoMy5nb29nbGV1c2VyY29udGVudC5jb20vYS9BQ2c4b2NKYmNzdWs0bFkxYzludm43cHlvWVZxUlp5YkdOQkVkT3JEeTZqNDBETzVYNER6OS1nPXM5Ni1jIiwiZ2l2ZW5fbmFtZSI6InNoYW5nanVuIiwiZmFtaWx5X25hbWUiOiJ5YW8iLCJpYXQiOjE3MzU1MjU5MzAsImV4cCI6MTczNTUyOTUzMCwianRpIjoiNGU1MTM3OGYwZTA3NjcyY2NlYWYxNmQxNTM2MGFkZTA5MWFjZDNiMSJ9.RRzy_Q6UkCSHtQfC8UkWEeVa58ouwqpSIaaP7cMZdOdzRHqtAEk055PcravyfxPQBakCxkskXjYdBtErSitOBvbCNnc3lWGjUZu4D2jqCJDfbkMPMatOW5i56VhCr9_hnN4LHtfEIaOotYijf2U1cjSMGqXxYf6aSfHLzHAfYJFkaac9fvdHKWqgPk5VnrWedPW49UZYTAAxQM-L4357RNnguTZzKqDngf3fhSF-66tkFDKrLbuGv595INA_vPUftPUUJby-2mXhV04feoTfehWwsbCfex98q24G0bKonF3tspnlhtP_10umDt3fmKQJTPXgySJFygkNqN5VZJ9E0Q";
        String CLIENT_ID = Config.get("google.client.id");
        HttpTransport transport = new ApacheHttpTransport();
        JsonFactory jsonFactory = new GsonFactory();
        GooglePublicKeysManager.Builder builder = new GooglePublicKeysManager.Builder(transport, jsonFactory);
        builder.setPublicCertsEncodedUrl("https://google-api.gsstcloud.com/oauth2/v1/certs");
        GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder(builder.build())
                .setAudience(Collections.singletonList(CLIENT_ID))
                .setIssuer("https://accounts.google.com")
                .build();
        GoogleIdToken idToken = verifier.verify(idTokenString);
        System.out.println(idToken);

    }

    @Resource
    private GoogleLoginChannel googleLoginChannel;

    @Test
    public void testGoogleLogin() throws Exception {
        MemberLoginRequestDto memberLoginRequest = new MemberLoginRequestDto();
        memberLoginRequest.setAuthCode("eyJhbGciOiJSUzI1NiIsImtpZCI6ImFiODYxNGZmNjI4OTNiYWRjZTVhYTc5YTc3MDNiNTk2NjY1ZDI0NzgiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhenAiOiI4Njc5ODUwMTY3NTktbjlxajAwazE3NG45YmlicnRycW5ndnQ4OXZibW5qcnAuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJhdWQiOiI4Njc5ODUwMTY3NTktbjlxajAwazE3NG45YmlicnRycW5ndnQ4OXZibW5qcnAuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJzdWIiOiIxMDQwNzE2MTExMDgxOTEzMDA4NTAiLCJlbWFpbCI6Inlhb3NoYW5nanVuMjRAZ21haWwuY29tIiwiZW1haWxfdmVyaWZpZWQiOnRydWUsIm5iZiI6MTczNTUyNTYzMCwibmFtZSI6InNoYW5nanVuIHlhbyIsInBpY3R1cmUiOiJodHRwczovL2xoMy5nb29nbGV1c2VyY29udGVudC5jb20vYS9BQ2c4b2NKYmNzdWs0bFkxYzludm43cHlvWVZxUlp5YkdOQkVkT3JEeTZqNDBETzVYNER6OS1nPXM5Ni1jIiwiZ2l2ZW5fbmFtZSI6InNoYW5nanVuIiwiZmFtaWx5X25hbWUiOiJ5YW8iLCJpYXQiOjE3MzU1MjU5MzAsImV4cCI6MTczNTUyOTUzMCwianRpIjoiNGU1MTM3OGYwZTA3NjcyY2NlYWYxNmQxNTM2MGFkZTA5MWFjZDNiMSJ9.RRzy_Q6UkCSHtQfC8UkWEeVa58ouwqpSIaaP7cMZdOdzRHqtAEk055PcravyfxPQBakCxkskXjYdBtErSitOBvbCNnc3lWGjUZu4D2jqCJDfbkMPMatOW5i56VhCr9_hnN4LHtfEIaOotYijf2U1cjSMGqXxYf6aSfHLzHAfYJFkaac9fvdHKWqgPk5VnrWedPW49UZYTAAxQM-L4357RNnguTZzKqDngf3fhSF-66tkFDKrLbuGv595INA_vPUftPUUJby-2mXhV04feoTfehWwsbCfex98q24G0bKonF3tspnlhtP_10umDt3fmKQJTPXgySJFygkNqN5VZJ9E0Q");
        googleLoginChannel.doLogin(memberLoginRequest);
    }
}
