package cn.com.poc.thirdparty.resource.demand.ai.function.document_understanding;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Message;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Parameters;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Properties;
import cn.com.poc.thirdparty.service.LLMService;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.File;
import java.util.List;

@Component
public class DocumentUnderstandIngFunction extends AbstractLargeModelFunction {

    @Resource
    private LLMService llmService;

    private final String MODEL = "Doubao-pro-128k";

    private final String TEMPLATE = "## 任务\n" +
            "你的任务是根据用户提出的问题，并且对于当前长文档内容理解，支持信息检索、摘要总结、文本分析能力。提取或者总结文档中与内容相关的内容。\n" +
            "\n" +
            "## 文档内容\n" +
            "${document_content}" +
            "\n" +
            "## 用户问题\n" +
            "${question}";

    private final String DESC = "长文档内容理解，支持信息检索、摘要总结、文本分析能力。";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig
            .FunctionLLMConfigBuilder()
            .name("document_understanding")
            .description(DESC)
            .parameters(new Parameters("object")
                    .addProperties("question", new Properties("string", "提炼用户的问题"))
                    .addProperties("file_url", new Properties("string", "doc、docx、pdf、txt、md、xlsx、csv、xls文件地址"))

            ).build();


    @Override
    public String doFunction(String content, String identifier) {
        if (StringUtils.isBlank(content)) {
            return StringUtils.EMPTY;
        }
        JSONObject jsonObject = JSON.parseObject(content);
        String question = jsonObject.getString("question");
        String fileUrl = jsonObject.getString("file_url");
        File file = DocumentLoad.downloadURLDocument(fileUrl);
        String documentContent = DocumentLoad.documentToText(file);

        Message message = new Message();
        message.setRole("user");
        message.setContent(TEMPLATE.replace("${document_content}", documentContent).replace("${question}", question));

        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel(MODEL);
        largeModelResponse.setMessages(new Message[]{message});
        largeModelResponse.setStream(false);
        largeModelResponse.setUser("Document_Understanding");
        LargeModelDemandResult largeModelDemandResult = llmService.chat(largeModelResponse);
        return largeModelDemandResult.getMessage();
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(this.functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return this.getLLMConfig();
    }
}
