package cn.com.poc.thirdparty.resource.demand.pay.service.impl;

import cn.com.poc.common.constant.BizSnKeyEnum;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.GeneratingSnUtils;
import cn.com.poc.thirdparty.resource.demand.pay.service.DgtoolsPayLogService;
import cn.com.poc.thirdparty.resource.demand.pay.service.DgtoolsPayOrderService;
import cn.com.poc.thirdparty.resource.demand.pay.constants.DgtoolsPayLogConstants;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayLogEntity;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayOrderEntity;
import cn.com.poc.thirdparty.resource.demand.pay.model.DgtoolsPayLogModel;
import cn.com.poc.thirdparty.resource.demand.pay.repository.DgtoolsPayLogRepository;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author Roger Wu
 */
@Service
public class DgtoolsPayLogServiceImpl extends BaseServiceImpl
        implements DgtoolsPayLogService {


    @Resource
    private DgtoolsPayOrderService dgtoolsPayOrderService;

    @Resource
    private DgtoolsPayLogRepository repository;

    @Override
    public void createPayLog(String payOrderSn) {
        DgtoolsPayOrderEntity payOrderByPaySn = dgtoolsPayOrderService.findPayOrderByPaySn(payOrderSn);
        if (payOrderByPaySn == null) {
            throw new BusinessException("找不到订单记录");
        }
        DgtoolsPayLogEntity payLogByPayOrderSn = this.findPayLogByPayOrderSn(payOrderSn);
        if (payLogByPayOrderSn == null) { //避免订单日志重复创建
            DgtoolsPayLogModel model = new DgtoolsPayLogModel();
            model.setPayLogSn(GeneratingSnUtils.generationSn(BizSnKeyEnum.payLogSn));
            model.setPayOrderSn(payOrderByPaySn.getPayOrderSn());
            model.setPaidAmount(payOrderByPaySn.getPaidAmount());
            model.setCurrency(payOrderByPaySn.getCurrency());
            model.setPayStatus(DgtoolsPayLogConstants.PayStatus.NO_PAYMENT);
            model.setPayTime(new Date());
            model.setMemberId(payOrderByPaySn.getMemberId());
            model.setMerchantId(payOrderByPaySn.getMerchantId());
            model.setCorpInfoId(payOrderByPaySn.getCorpInfoId());
            repository.save(model);
        }
    }

    /**
     * 更新支付流水
     *
     * @param payOrderSn
     * @param thirdParthPayLogSn
     */
    @Override
    public void changePayLog2PaidStatus(String payOrderSn, String thirdParthPayLogSn) {
        DgtoolsPayLogModel example = new DgtoolsPayLogModel();
        example.setPayOrderSn(payOrderSn);
        example.setIsDeleted(CommonConstant.IsDeleted.N);
        List<DgtoolsPayLogModel> dgtoolsPayLogModelList = repository.findByExample(example);
        if (CollectionUtils.isEmpty(dgtoolsPayLogModelList)) {
            return;
        }
        DgtoolsPayLogModel dgtoolsPayLogModel = dgtoolsPayLogModelList.get(0);
        dgtoolsPayLogModel.setThirdParthPayLogSn(thirdParthPayLogSn);
        dgtoolsPayLogModel.setPayStatus(DgtoolsPayLogConstants.PayStatus.PAID);
        dgtoolsPayLogModel.setPayTime(new Date());
        repository.save(dgtoolsPayLogModel);
    }


    /**
     * 根据订单号查询支付记录
     *
     * @param payOrderSn
     * @return
     * @throws BusinessException
     */
    @Override
    public DgtoolsPayLogEntity findPayLogByPayOrderSn(String payOrderSn) throws BusinessException {
        DgtoolsPayLogModel example = new DgtoolsPayLogModel();
        example.setPayOrderSn(payOrderSn);
        example.setIsDeleted(CommonConstant.IsDeleted.N);
        List<DgtoolsPayLogModel> dgtoolsPayLogModelList = repository.findByExample(example);
        if (CollectionUtils.isEmpty(dgtoolsPayLogModelList)) {
            return null;
        }
        DgtoolsPayLogEntity savedEntity = new DgtoolsPayLogEntity();
        BeanUtils.copyProperties(dgtoolsPayLogModelList.get(0), savedEntity);
        return savedEntity;
    }

}