package cn.com.poc.thirdparty.service;

import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Tool;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;

import java.io.BufferedReader;

/**
 * 大模型 服务
 *
 * @author alex.yao
 * @date 2023/11/21
 **/
public interface LLMService {

    /**
     * 对话 【非流】
     *
     * @param response
     * @return
     */
    LargeModelDemandResult chat(LargeModelResponse response);


    /**
     * 对话 【流】
     *
     * @param request
     */
    BufferedReader chatChunk(LargeModelResponse request) throws Exception;

    /**
     * functionCall判断
     *
     * @param query
     * @param tools
     */
    FunctionCallResult functionCall(String query, Tool[] tools);


}
