package cn.com.poc.equity.aggregate.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.equity.aggregate.EquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.domain.AgentEquity;
import cn.com.poc.equity.entity.BizPaymentPackageConfigurationEntity;
import cn.com.poc.equity.service.BizPaymentPackageConfigurationService;
import cn.com.poc.thirdparty.resource.demand.dgTools.constants.CurrencyEnum;
import cn.com.poc.thirdparty.resource.demand.pay.constants.DgtoolsPayOrderConstants;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayOrderEntity;
import cn.com.poc.thirdparty.resource.demand.pay.service.DgtoolsPayOrderService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Component
public class EquityServiceImpl implements EquityService {

    private final Logger logger = LoggerFactory.getLogger(EquityService.class);

    @Resource
    private BizPaymentPackageConfigurationService bizPaymentPackageConfigurationService;

    @Resource
    private DgtoolsPayOrderService dgtoolsPayOrderService;

    @Override
    public List<AgentEquity> getEquityList(EquityEnum.TYPE type) {
        List<AgentEquity> result = new ArrayList<>();
        BizPaymentPackageConfigurationEntity bizPaymentPackageConfigurationEntity = new BizPaymentPackageConfigurationEntity();
        bizPaymentPackageConfigurationEntity.setType(type.name());
        bizPaymentPackageConfigurationEntity.setDomain(EquityEnum.DOMAIN.equity.name());
        bizPaymentPackageConfigurationEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizPaymentPackageConfigurationEntity> entities = bizPaymentPackageConfigurationService.findByExample(bizPaymentPackageConfigurationEntity, null);
        if (CollectionUtils.isNotEmpty(entities)) {
            for (BizPaymentPackageConfigurationEntity entity : entities) {
                AgentEquity agentEquity = new AgentEquity();
                String extraData = entity.getExtraData();
                if (StringUtils.isNotBlank(extraData)) {
                    agentEquity = JsonUtils.deSerialize(extraData, AgentEquity.class);
                }
                agentEquity.setAmount(entity.getAmount().longValue());
                agentEquity.setPoints(entity.getResourceCount().longValue());
                agentEquity.setValidityUnit(EquityEnum.VALIDITY_UNIT.valueOf(entity.getExpiredType()));
                result.add(agentEquity);
            }
        }
        return result;
    }

    @Override
    public List<BizPaymentPackageConfigurationEntity> getPointList() {
        BizPaymentPackageConfigurationEntity bizPaymentPackageConfigurationEntity = new BizPaymentPackageConfigurationEntity();
        bizPaymentPackageConfigurationEntity.setDomain(EquityEnum.DOMAIN.point.name());
        bizPaymentPackageConfigurationEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizPaymentPackageConfigurationEntity> entities = bizPaymentPackageConfigurationService.findByExample(bizPaymentPackageConfigurationEntity, null);
        return entities;
    }

    @Override
    public String createEquityOrder(EquityEnum.TYPE type, EquityEnum.DOMAIN domain, EquityEnum.VALIDITY_UNIT validityUnit, Long memberId) throws Exception {
        logger.info("创建权益订单,type:{},domain:{},validity_unit:{},member_id:{}", type, domain, validityUnit, memberId);
        BizPaymentPackageConfigurationEntity bizPaymentPackageConfigurationEntity = new BizPaymentPackageConfigurationEntity();
        bizPaymentPackageConfigurationEntity.setType(type.name());
        bizPaymentPackageConfigurationEntity.setDomain(domain.name());
        bizPaymentPackageConfigurationEntity.setExpiredType(validityUnit.name());
        bizPaymentPackageConfigurationEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizPaymentPackageConfigurationEntity> paymentPackageConfigurationEntities = bizPaymentPackageConfigurationService.findByExample(bizPaymentPackageConfigurationEntity, null);
        if (CollectionUtils.isEmpty(paymentPackageConfigurationEntities)) {
            throw new I18nMessageException("exception/payment.package.configuration.not.exist");
        }
        BizPaymentPackageConfigurationEntity packageConfiguration = paymentPackageConfigurationEntities.get(0);
        DgtoolsPayOrderEntity dgtoolsPayOrderEntity = new DgtoolsPayOrderEntity();
        dgtoolsPayOrderEntity.setAmount(packageConfiguration.getAmount());
        dgtoolsPayOrderEntity.setPayOrderType(domain.name());
        dgtoolsPayOrderEntity.setMemberId(memberId.intValue());
        dgtoolsPayOrderEntity.setCurrency(CurrencyEnum.CHINA.getCurrencyCode());
        dgtoolsPayOrderEntity.setDescription(packageConfiguration.getName());
        dgtoolsPayOrderEntity.setRetainInformation(JsonUtils.serialize(packageConfiguration));

        // 创建支付订单-支付中台
        DgtoolsPayOrderEntity payOrder = dgtoolsPayOrderService.createPayOrder(dgtoolsPayOrderEntity, memberId);
        logger.info("创建支付订单,pay_order:{}", JsonUtils.serialize(payOrder));
        return payOrder.getPayOrderSn();
    }
}
