package cn.com.poc.equity.processor;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.equity.aggregate.MemberEquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.constants.ModifyEventEnum;
import cn.com.poc.equity.domain.modifyEquityInfo.PayModifyEventInfo;
import cn.com.poc.equity.entity.BizPaymentPackageConfigurationEntity;
import cn.com.poc.thirdparty.resource.demand.pay.constants.DgtoolsPayOrderConstants;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayOrderEntity;
import cn.com.poc.thirdparty.resource.demand.pay.processor.AbstractPayPostProcessor;
import cn.com.poc.thirdparty.resource.demand.pay.service.DgtoolsPayOrderService;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2024/12/9
 */
@Component
public class EquityPayPostProcessor implements AbstractPayPostProcessor {

    @Resource
    private MemberEquityService memberEquityService;

    @Resource
    private DgtoolsPayOrderService dgtoolsPayOrderService;

    @Override
    public boolean support(String payOrderType) {
        return DgtoolsPayOrderConstants.PayOrderType.EQUITY.equals(payOrderType);
    }

    @Override
    public boolean postProcessSuccess(String orderSn) {
        try {
            PayModifyEventInfo modifyEventInfo = new PayModifyEventInfo();
            modifyEventInfo.setPayOrderSn(orderSn);
            DgtoolsPayOrderEntity payOrderEntity = dgtoolsPayOrderService.findPayOrderByPaySn(orderSn);
            if (payOrderEntity == null) {
                throw new BusinessException("支付回调,找不到账单信息");
            }
            String retainInformation = payOrderEntity.getRetainInformation();
            Integer memberId = payOrderEntity.getMemberId();
            BizPaymentPackageConfigurationEntity bizPaymentPackageConfigurationEntity = JsonUtils.deSerialize(retainInformation, BizPaymentPackageConfigurationEntity.class);
            String type = bizPaymentPackageConfigurationEntity.getType();
            String domain = bizPaymentPackageConfigurationEntity.getDomain();
            String expiredType = bizPaymentPackageConfigurationEntity.getExpiredType();
            if (EquityEnum.DOMAIN.equity.name().equals(domain)) {
                //更新权益
                memberEquityService.changeEquityLevel(memberId.longValue(), ModifyEventEnum.top_up, EquityEnum.TYPE.valueOf(type), EquityEnum.VALIDITY_UNIT.valueOf(expiredType), modifyEventInfo);
            }
            memberEquityService.addPoint(memberId.longValue(), bizPaymentPackageConfigurationEntity.getResourceCount().longValue(), EquityEnum.VALIDITY_UNIT.valueOf(expiredType), ModifyEventEnum.top_up, modifyEventInfo);
            return true;
        } catch (Exception e) {
            //todo 异常处理
            return false;
        }
    }

    @Override
    public void postProcessFail(String orderSn) {

    }
}
