package cn.com.poc.equity.rest;


import cn.com.poc.equity.dto.CurrentUserEquityInfoDto;
import cn.com.poc.equity.dto.EquityPackagesDto;
import cn.com.poc.equity.dto.PointPackagesDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;

@Permission(Access.Anonymous)
public interface EquityRest extends BaseRest {

    /**
     * 获取会员权益充值包列表，专业版 /  旗舰版
     *
     * @return
     */
    EquityPackagesDto getPackageList();

    /**
     * 获取积分充值包列表
     */
    PointPackagesDto getPointPackageList();

    /**
     * 获取当前会员权益等级
     *
     * @return
     */
    @Permission(Access.Safety)
    CurrentUserEquityInfoDto getCurrentEquityLevel() throws Exception;
}
