package cn.com.poc.equity.rest.impl;

import cn.com.poc.common.utils.BlContext;
import cn.com.poc.equity.aggregate.EquityService;
import cn.com.poc.equity.aggregate.MemberEquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.domain.AgentEquity;
import cn.com.poc.equity.domain.PointEquityInfo;
import cn.com.poc.equity.dto.CurrentUserEquityInfoDto;
import cn.com.poc.equity.dto.EquityPackagesDto;
import cn.com.poc.equity.dto.PointPackagesDto;
import cn.com.poc.equity.entity.BizPaymentPackageConfigurationEntity;
import cn.com.poc.equity.rest.EquityRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class EquityRestImpl implements EquityRest {


    @Resource
    private EquityService equityService;

    @Resource
    private MemberEquityService memberEquityService;

    @Override
    public EquityPackagesDto getPackageList() {
        List<AgentEquity> professinalList = equityService.getEquityList(EquityEnum.TYPE.professional);
        List<AgentEquity> ultimateList = equityService.getEquityList(EquityEnum.TYPE.ultimate);
        EquityPackagesDto equityPackagesDto = new EquityPackagesDto();
        equityPackagesDto.setProfessional(professinalList);
        equityPackagesDto.setUltimate(ultimateList);
        return equityPackagesDto;
    }


    @Override
    public PointPackagesDto getPointPackageList() {
        PointPackagesDto result = new PointPackagesDto();
        List<BizPaymentPackageConfigurationEntity> pointList = equityService.getPointList();
        for (BizPaymentPackageConfigurationEntity bizPaymentPackageConfigurationEntity : pointList) {
            PointEquityInfo pointEquityInfo = new PointEquityInfo();
            String type = bizPaymentPackageConfigurationEntity.getType();
            Integer amount = bizPaymentPackageConfigurationEntity.getAmount();
            Integer points = bizPaymentPackageConfigurationEntity.getResourceCount();
            pointEquityInfo.setPoints(points.longValue());
            pointEquityInfo.setAmount(amount.longValue());
            if (type.equals(EquityEnum.TYPE.normal.name())) {
                result.setNormal(pointEquityInfo);
            } else if (type.equals(EquityEnum.TYPE.professional.name())) {
                result.setProfessional(pointEquityInfo);
            } else if (type.equals(EquityEnum.TYPE.ultimate.name())) {
                result.setUltimate(pointEquityInfo);
            }
        }
        return result;
    }

    @Override
    public CurrentUserEquityInfoDto getCurrentEquityLevel() throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        String memberEquityLevel = memberEquityService.getMemberEquityLevel(userBaseEntity.getUserId());
        CurrentUserEquityInfoDto currentUserEquityInfoDto = new CurrentUserEquityInfoDto();
        currentUserEquityInfoDto.setEquityLevel(memberEquityLevel);
        return currentUserEquityInfoDto;
    }
}
